package io.github.qsy7.linux.builder.impl.service.hostname;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

public class DebianHostnameService extends AbstractLinuxHostnameService {
  @Inject
  public DebianHostnameService(final BuildConfiguration buildConfiguration) {
    super(buildConfiguration.getRootDirectory());
  }

  @Override
  protected void doSet(String hostname) throws IOException {
    FileUtils.write(getHostnameFile(), hostname + "\n", "UTF-8", false);
  }

  protected File getHostnameFile() {
    return (new File(rootDirectory + "/etc/hostname"));
  }
}
