package io.github.qsy7.linux.builder.impl.service.provider;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.linux.builder.api.service.HostnameService;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import javax.inject.Inject;
import javax.inject.Provider;

public class HostnameServiceProvider implements Provider<HostnameService> {
  protected final HostnameService hostnameService;

  @Inject
  public HostnameServiceProvider(DistributionConfiguration distributionConfiguration) {

    this.hostnameService =
        ApplicationHelper.getApplicationInstance()
            .getInjector()
            .getInstance(distributionConfiguration.getImplementingHostnameServiceClass());
  }

  @Override
  public HostnameService get() {
    return hostnameService;
  }
}
