package io.github.qsy7.linux.builder.impl.service.provider;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.linux.builder.api.service.RunlevelManagementService;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import javax.inject.Inject;
import javax.inject.Provider;

public class RunlevelManagementServiceProvider implements Provider<RunlevelManagementService> {
  protected final RunlevelManagementService runlevelManagementService;

  @Inject
  public RunlevelManagementServiceProvider(DistributionConfiguration distributionConfiguration) {

    this.runlevelManagementService =
        ApplicationHelper.getApplicationInstance()
            .getInjector()
            .getInstance(distributionConfiguration.getImplementingRunlevelManagementServiceClass());
  }

  @Override
  public RunlevelManagementService get() {
    return runlevelManagementService;
  }
}
