package io.github.qsy7.linux.builder.impl.service.bootstrap;

import io.github.qsy7.linux.builder.api.model.BuildPhase;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.service.DistributionBootstrappingService;
import java.io.File;
import org.apache.commons.io.FileUtils;

public abstract class AbstractLinuxBootstrappingService
    implements DistributionBootstrappingService {
  protected final BuildConfiguration buildConfiguration;

  protected AbstractLinuxBootstrappingService(BuildConfiguration buildConfiguration) {

    this.buildConfiguration = buildConfiguration;
  }

  @Override
  public void doBootstrap() throws Exception {
    // clear out /etc/fstab
    new File(buildConfiguration.getRootDirectory() + File.separator + "etc/fstab").delete();

    // clear out /etc/resolv.conf (symlink on Ubuntu)
    new File(buildConfiguration.getRootDirectory() + File.separator + "etc/resolv.conf").delete();

    // copy host /etc/resolv.conf
    FileUtils.copyFile(
        new File("/etc/resolv.conf"),
        new File(buildConfiguration.getRootDirectory() + "/etc/resolv.conf"));
  }

  @Override
  public void doPreBuild(BuildPhase buildPhase) throws Exception {}

  @Override
  public void doPostBuild(BuildPhase buildPhase) throws Exception {}
}
