package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.StringConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.packagemanagement.FlatpakPackageManagementService;
import io.github.qsy7.linux.builder.impl.service.util.configuration.StringConfigurer;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = StringConfigurer.class,
    configurationClass = StringConfiguration.class)
public class FlatpakAddPackagesModule extends AbstractSingleModule<StringConfiguration> {
  protected final FlatpakPackageManagementService flatpakPackageManagementService;

  @Inject
  public FlatpakAddPackagesModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      FlatpakPackageManagementService flatpakPackageManagementService) {
    super(buildService, buildConfiguration, distributionConfiguration);
    this.flatpakPackageManagementService = flatpakPackageManagementService;
  }

  @Override
  public void document() {}

  @Override
  protected void doRun() throws Exception {
    final String[] packageNames = configuration.getContent().split("\n");
    flatpakPackageManagementService.install(packageNames);
  }
}
