package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.User;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.api.service.UseraddService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.configuration.YamlConfigurer;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = YamlConfigurer.class,
    configurationClass = User.class)
public class UsersModule extends AbstractCollectionModule<User> {
  protected final UseraddService useraddService;

  @Inject
  public UsersModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      UseraddService useraddService) {
    super(buildService, buildConfiguration, distributionConfiguration);
    this.useraddService = useraddService;
  }

  @Override
  protected void doRun(User user) {
    useraddService.create(user);
  }

  @Override
  public void document() {}
}
