package io.github.qsy7.linux.builder.impl.service.packagemanagement;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import javax.inject.Inject;

public class FuntooEmergePackageManagementService extends EmergePackageManagementService {
  @Inject
  public FuntooEmergePackageManagementService(
      ShellExecutionService shellExecutionService,
      ShellCommandBuilder shellCommandBuilder,
      BuildConfiguration buildConfiguration) {
    super(shellExecutionService, shellCommandBuilder, buildConfiguration);
  }

  @Override
  public void update() throws Exception {
    run(
        "ego sync",
        "emerge --quiet --quiet-build y --nospinner --color n --update --newuse --deep"
            + " --with-bdeps=y @world",
        "emerge --newuse -uD --quiet --quiet-build y --nospinner --color n @world",
        "emerge --quiet --quiet-build y --nospinner --color n --depclean",
        "emerge --quiet --quiet-build y --nospinner --color n @preserved-rebuild"
        /*"eclean-dist --deep"*/ );
    // run eclean-dist outside and combine both workstation and router world files
  }

  public boolean isInstalled(String packageName) throws Exception {
    return run("equery l " + packageName).getReturnCode() == 0;
  }
}
