package io.github.qsy7.linux.builder.impl.service.util.configuration;

import io.github.qsy7.linux.builder.api.model.configuration.Configurable;
import io.github.qsy7.linux.builder.api.model.configuration.StringConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.IOUtil;
import java.io.File;
import java.io.IOException;

public class StringConfigurer implements Configurer {
  /** ie. read add.packages */
  public StringConfiguration read(
      final File path, final Class<? extends Configurable> type, final boolean isCollection)
      throws IOException {
    final StringBuilder buffer = new StringBuilder();
    for (final String line : IOUtil.readLines(path.getAbsolutePath())) {
      buffer.append(line + "\n");
    }

    return (new StringConfiguration(buffer.toString()));
  }
}
