/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.bootstrap;

import io.github.qsy7.file.api.service.DirectoryCopierService;
import io.github.qsy7.linux.builder.api.model.BuildPhase;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.service.PackageManagementService;
import io.github.qsy7.linux.builder.impl.service.bootstrap.AbstractLinuxBootstrappingService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;

public class FreeBSDBootstrappingService
extends AbstractLinuxBootstrappingService {
    protected final ShellExecutionService shellExecutionService;
    protected final PackageManagementService packageManagementService;
    protected final DirectoryCopierService directoryCopierService;

    /*
     * WARNING - void declaration
     */
    @Inject
    public FreeBSDBootstrappingService(ShellExecutionService shellExecutionService, BuildConfiguration buildConfiguration, PackageManagementService packageManagementService, DirectoryCopierService directoryCopierService) {
        void directoryCopierService2;
        void buildConfiguration2;
        void packageManagementService2;
        void shellExecutionService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"<init>", (Object[])new Object[]{shellExecutionService, buildConfiguration, packageManagementService, directoryCopierService});
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        PackageManagementService packageManagementService3 = packageManagementService;
        DirectoryCopierService directoryCopierService3 = directoryCopierService;
        super((BuildConfiguration)packageManagementService2);
        shellExecutionService2.shellExecutionService = buildConfiguration2;
        shellExecutionService2.packageManagementService = directoryCopierService2;
        shellExecutionService2.directoryCopierService = directoryCopierService3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"<init>", (Object[])new Object[]{shellExecutionService, buildConfiguration, packageManagementService, directoryCopierService}, null, (long)l);
    }

    @Override
    public void doBootstrap() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doBootstrap", (Object[])new Object[0]);
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        super.doBootstrap();
        if (freeBSDBootstrappingService.doesJailAlreadyExist()) {
            freeBSDBootstrappingService.shellExecutionService.run(new ShellCommand().withCommandLine("ezjail-admin create " + freeBSDBootstrappingService.buildConfiguration.getVariant() + " " + freeBSDBootstrappingService.getJailNetworkConfiguration()));
        }
        freeBSDBootstrappingService.shellExecutionService.run(new ShellCommand().withCommandLine("ezjail-admin start " + freeBSDBootstrappingService.buildConfiguration.getVariant()));
        freeBSDBootstrappingService.copyResolvConf();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doBootstrap", (Object[])new Object[0], null, (long)l);
    }

    protected boolean doesJailAlreadyExist() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doesJailAlreadyExist", (Object[])new Object[0]);
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        File file = new File("/usr/share/jails/" + freeBSDBootstrappingService.buildConfiguration.getVariant());
        boolean bl = file.exists();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doesJailAlreadyExist", (Object[])new Object[0], (Object)bl, (long)l);
        return bl;
    }

    protected String getJailNetworkConfiguration() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"getJailNetworkConfiguration", (Object[])new Object[0]);
        Object object = this;
        object = "lo1|127.0.1.2,em0|192.168.1.50";
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"getJailNetworkConfiguration", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    protected void copyResolvConf() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"copyResolvConf", (Object[])new Object[0]);
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        freeBSDBootstrappingService.directoryCopierService.copy(new File("/etc/resolv.conf").toPath(), new File("/usr/jails/" + freeBSDBootstrappingService.buildConfiguration.getVariant() + "/etc/resolv.conf").toPath());
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"copyResolvConf", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doPreBuild(BuildPhase buildPhase) throws Exception {
        void buildPhase2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doPreBuild", (Object[])new Object[]{buildPhase});
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        BuildPhase buildPhase3 = buildPhase;
        super.doPreBuild(buildPhase3);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doPreBuild", (Object[])new Object[]{buildPhase}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doPostBuild(BuildPhase buildPhase) throws Exception {
        void buildPhase2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doPostBuild", (Object[])new Object[]{buildPhase});
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        BuildPhase buildPhase3 = buildPhase;
        super.doPostBuild(buildPhase3);
        if (buildPhase3.equals((Object)BuildPhase.Setup)) {
            // empty if block
        }
        buildPhase2.packageManagementService.update();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doPostBuild", (Object[])new Object[]{buildPhase}, null, (long)l);
    }

    public void doCompletion() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doCompletion", (Object[])new Object[0]);
        FreeBSDBootstrappingService freeBSDBootstrappingService = this;
        freeBSDBootstrappingService.shellExecutionService.run(new ShellCommand().withCommandLine("ezjail-admin stop " + freeBSDBootstrappingService.buildConfiguration.getVariant()));
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.bootstrap.FreeBSDBootstrappingService", (String)"doCompletion", (Object[])new Object[0], null, (long)l);
    }
}

