/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.build;

import com.google.common.eventbus.EventBus;
import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.linux.builder.api.model.BuildPhase;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.patch.Patch;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.api.service.DistributionBootstrappingService;
import io.github.qsy7.linux.builder.api.service.Module;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil;
import io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.enumeration.MountAction;
import io.github.qsy7.shell.api.model.MountCommand;
import io.github.qsy7.shell.api.model.MountPoint;
import io.github.qsy7.shell.api.service.MountService;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultBuildService
implements BuildService {
    protected final ModuleFactory moduleFactory;
    protected final EventBus eventBus;
    protected final MountService mountService;
    protected final DistributionBootstrappingService distributionBootstrappingService;
    protected final BuildConfiguration buildConfiguration;
    protected final DistributionConfiguration distributionConfiguration;
    protected boolean clean;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultBuildService(ModuleFactory moduleFactory, EventBus eventBus, MountService mountService, DistributionBootstrappingService distributionBootstrappingService, BuildConfiguration buildConfiguration, DistributionConfiguration distributionConfiguration) {
        void distributionConfiguration2;
        void buildConfiguration2;
        void distributionBootstrappingService2;
        void mountService2;
        void eventBus2;
        void moduleFactory2;
        Object object = this;
        ModuleFactory moduleFactory3 = moduleFactory;
        EventBus eventBus3 = eventBus;
        MountService mountService3 = mountService;
        DistributionBootstrappingService distributionBootstrappingService3 = distributionBootstrappingService;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"<init>", (Object[])new Object[]{moduleFactory3, eventBus3, mountService3, distributionBootstrappingService3, buildConfiguration3, distributionConfiguration3});
        DefaultBuildService defaultBuildService = object;
        ModuleFactory moduleFactory4 = moduleFactory3;
        EventBus eventBus4 = eventBus3;
        MountService mountService4 = mountService3;
        DistributionBootstrappingService distributionBootstrappingService4 = distributionBootstrappingService3;
        BuildConfiguration buildConfiguration4 = buildConfiguration3;
        DistributionConfiguration distributionConfiguration4 = distributionConfiguration3;
        moduleFactory2.clean = true;
        moduleFactory2.moduleFactory = eventBus2;
        moduleFactory2.eventBus = mountService2;
        moduleFactory2.mountService = distributionBootstrappingService2;
        moduleFactory2.distributionBootstrappingService = buildConfiguration2;
        moduleFactory2.buildConfiguration = distributionConfiguration2;
        moduleFactory2.distributionConfiguration = distributionConfiguration4;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"<init>", (Object[])new Object[]{moduleFactory3, eventBus3, mountService3, distributionBootstrappingService3, buildConfiguration3, distributionConfiguration3}, null, (long)l);
        object = (AutoCloseable)((Object)this);
        CloseableUtil.addAutoCloseable((AutoCloseable)object);
    }

    protected void onSetup() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"onSetup", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        System.setProperty("~/", defaultBuildService.buildConfiguration.getBuildDirectory());
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"onSetup", (Object[])new Object[0], null, (long)l);
    }

    public void build() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"build", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        defaultBuildService.onSetup();
        if (defaultBuildService.buildConfiguration.getSinglePatchName() != null) {
            defaultBuildService.doSinglePatch();
        } else {
            defaultBuildService.doAllPatches();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"build", (Object[])new Object[0], null, (long)l);
    }

    protected void doSinglePatch() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doSinglePatch", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        if (!defaultBuildService.buildConfiguration.isOnLiveHost()) {
            try {
                defaultBuildService.mount();
                defaultBuildService.doPatch(defaultBuildService.buildConfiguration.getSinglePatchName());
            }
            finally {
                defaultBuildService.close();
            }
        } else {
            defaultBuildService.doPatch(defaultBuildService.buildConfiguration.getSinglePatchName());
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doSinglePatch", (Object[])new Object[0], null, (long)l);
    }

    protected void doAllPatches() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doAllPatches", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        defaultBuildService.doSystem();
        defaultBuildService.distributionBootstrappingService.doBootstrap();
        try {
            defaultBuildService.mount();
            defaultBuildService.doPatches();
        }
        finally {
            defaultBuildService.close();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doAllPatches", (Object[])new Object[0], null, (long)l);
    }

    protected void doSystem() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doSystem", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        defaultBuildService.runPatch(new Patch("system", defaultBuildService.buildConfiguration.getScmConfiguration().getWorkspacePath() + File.separator + "systems" + File.separator + defaultBuildService.buildConfiguration.getVariant() + File.separator + "system.patch", false), BuildPhase.Setup);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doSystem", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doPatch(String string) throws Exception {
        void patchName;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doPatch", (Object[])new Object[]{string});
        DefaultBuildService defaultBuildService = this;
        String string2 = string;
        Patch patch = DependencyManagementUtil.getPatchByName(patchName.buildConfiguration.getScmConfiguration().getWorkspacePath(), patchName.buildConfiguration.getVariant(), string2);
        patchName.doPatches(patch);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doPatch", (Object[])new Object[]{string}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doPatches() throws Exception {
        void patches;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doPatches", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        List<Patch> list = DependencyManagementUtil.getOrderedSystemPatches(defaultBuildService.buildConfiguration.getScmConfiguration().getWorkspacePath(), defaultBuildService.buildConfiguration.getVariant());
        patches.doPatches(list.toArray(new Patch[list.size()]));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doPatches", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doPatches(Patch ... patchArray) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doPatches", (Object[])new Object[]{patchArray});
        DefaultBuildService defaultBuildService = this;
        Patch[] patchArray2 = patchArray;
        for (BuildPhase buildPhase : BuildPhase.values()) {
            void patches;
            patches.distributionBootstrappingService.doPreBuild(buildPhase);
            patches.runBuildPhase(buildPhase, patchArray2);
            patches.distributionBootstrappingService.doPostBuild(buildPhase);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"doPatches", (Object[])new Object[]{patchArray}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void runBuildPhase(BuildPhase buildPhase, Patch ... patchArray) throws Exception {
        Patch[] patchArray2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runBuildPhase", (Object[])new Object[]{buildPhase, patchArray});
        DefaultBuildService defaultBuildService = this;
        BuildPhase buildPhase2 = buildPhase;
        for (Patch patch : patchArray2 = patchArray) {
            void patches;
            void buildPhase3;
            buildPhase3.runPatch(patch, (BuildPhase)patches);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runBuildPhase", (Object[])new Object[]{buildPhase, patchArray}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void runPatch(Patch patch, BuildPhase buildPhase) throws Exception {
        void buildPhase2;
        void patch2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatch", (Object[])new Object[]{patch, buildPhase});
        DefaultBuildService defaultBuildService = this;
        Patch patch3 = patch;
        BuildPhase buildPhase3 = buildPhase;
        patch2.runPatchMain((Patch)buildPhase2, buildPhase3);
        patch2.runPatchVariant((Patch)buildPhase2, buildPhase3);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatch", (Object[])new Object[]{patch, buildPhase}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void runPatchMain(Patch patch, BuildPhase buildPhase) throws Exception {
        void buildPhase2;
        void patch2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatchMain", (Object[])new Object[]{patch, buildPhase});
        DefaultBuildService defaultBuildService = this;
        Patch patch3 = patch;
        BuildPhase buildPhase3 = buildPhase;
        patch2.runPatchModules(patch2.moduleFactory.produceModules((BuildService)patch2, (Patch)buildPhase2, buildPhase3));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatchMain", (Object[])new Object[]{patch, buildPhase}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean runPatchVariant(Patch patch, BuildPhase buildPhase) throws Exception {
        boolean bl;
        void buildPhase2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatchVariant", (Object[])new Object[]{patch, buildPhase});
        DefaultBuildService defaultBuildService = this;
        Patch patch2 = patch;
        BuildPhase buildPhase3 = buildPhase;
        if (buildPhase2.isDoesVariantExist()) {
            void patch3;
            patch3.runPatchModules(patch3.moduleFactory.produceModules((BuildService)patch3, (Patch)buildPhase2, buildPhase3, patch3.buildConfiguration.getVariant()));
            bl = true;
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatchVariant", (Object[])new Object[]{patch, buildPhase}, (Object)bl2, (long)l);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    protected void runPatchModules(List<Module> list) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatchModules", (Object[])new Object[]{list});
        DefaultBuildService defaultBuildService = this;
        List<Module> list2 = list;
        if (list2 != null) {
            for (Module module : list2) {
                void modules;
                modules.runModule(module);
            }
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runPatchModules", (Object[])new Object[]{list}, null, (long)l);
    }

    protected void runModule(Module module) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runModule", (Object[])new Object[]{module});
        DefaultBuildService defaultBuildService = this;
        Module module2 = module;
        if (module2 != null && module2.isRun()) {
            module2.document();
            module2.run();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"runModule", (Object[])new Object[]{module}, null, (long)l);
    }

    protected void mount() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"mount", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        defaultBuildService.mount(defaultBuildService.buildConfiguration.getRootDirectory(), defaultBuildService.distributionConfiguration);
        defaultBuildService.clean = false;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"mount", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void mount(String string, DistributionConfiguration distributionConfiguration) throws Exception {
        void distributionConfiguration2;
        void rootDirectory;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"mount", (Object[])new Object[]{string, distributionConfiguration});
        DefaultBuildService defaultBuildService = this;
        String string2 = string;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        for (MountPoint mountPoint : distributionConfiguration3.getMountPoints()) {
            rootDirectory.mountService.execute((AbstractEntity)new MountCommand().withRootPath((String)distributionConfiguration2).withMountAction(MountAction.Mount).withMountPoint(mountPoint));
        }
        if (distributionConfiguration3.getParent() != null) {
            rootDirectory.mount((String)distributionConfiguration2, distributionConfiguration3.getParent());
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"mount", (Object[])new Object[]{string, distributionConfiguration}, null, (long)l);
    }

    protected void unmount() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"unmount", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        if (!defaultBuildService.clean) {
            defaultBuildService.unmount(defaultBuildService.buildConfiguration.getRootDirectory(), defaultBuildService.distributionConfiguration);
        }
        defaultBuildService.clean = true;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"unmount", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void unmount(String string, DistributionConfiguration distributionConfiguration) throws Exception {
        void distributionConfiguration2;
        void rootDirectory;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"unmount", (Object[])new Object[]{string, distributionConfiguration});
        DefaultBuildService defaultBuildService = this;
        String string2 = string;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        for (MountPoint mountPoint : distributionConfiguration3.getUmountPoints()) {
            rootDirectory.mountService.execute((AbstractEntity)new MountCommand().withRootPath((String)distributionConfiguration2).withMountAction(MountAction.Unmount).withMountPoint(mountPoint));
        }
        if (distributionConfiguration3.getParent() != null) {
            rootDirectory.unmount((String)distributionConfiguration2, distributionConfiguration3.getParent());
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"unmount", (Object[])new Object[]{string, distributionConfiguration}, null, (long)l);
    }

    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"close", (Object[])new Object[0]);
        DefaultBuildService defaultBuildService = this;
        try {
            defaultBuildService.unmount();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error unmounting", exception);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.build.DefaultBuildService", (String)"close", (Object[])new Object[0], null, (long)l);
    }
}

