/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.installation;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.InstallationConfiguration;
import io.github.qsy7.linux.builder.api.service.InstallationService;
import io.github.qsy7.linux.builder.impl.service.GetCurrentRootDeviceTimeout;
import io.github.qsy7.linux.builder.impl.service.MakeRemoteSystemUpdateDirectoryTimeout;
import io.github.qsy7.linux.builder.impl.service.installation.SSHInstallationUsername;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import io.github.qsy7.ssh.api.SFTPTransferService;
import io.github.qsy7.ssh.api.SSHCommandService;
import io.github.qsy7.ssh.api.model.SSHHost;
import io.github.qsy7.ssh.api.model.SSHUser;
import io.github.qsy7.ssh.api.model.command.SSHCommand;
import io.github.qsy7.ssh.api.model.sftp.SFTPTransfer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;

public class UnixHostInstallationService
implements InstallationService {
    protected final ShellCommandBuilder shellCommandBuilder;
    protected final SSHCommandService sshCommandService;
    protected final SFTPTransferService sftpTransferService;
    protected final ShellExecutionService shellExecutionService;
    protected final int getCurrentRootDeviceTimeout;
    protected final int makeRemoteSystemUpdateDirectoryTimeout;
    protected final String sshUsername;

    /*
     * WARNING - void declaration
     */
    @Inject
    public UnixHostInstallationService(ShellCommandBuilder shellCommandBuilder, SSHCommandService sSHCommandService, SFTPTransferService sFTPTransferService, ShellExecutionService shellExecutionService, @Property(value=SSHInstallationUsername.class) String string, @Property(value=GetCurrentRootDeviceTimeout.class) int n, @Property(value=MakeRemoteSystemUpdateDirectoryTimeout.class) int n2) {
        void makeRemoteSystemUpdateDirectoryTimeout;
        void getCurrentRootDeviceTimeout;
        void sshUsername;
        void shellExecutionService2;
        void sftpTransferService;
        void sshCommandService;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, sSHCommandService, sFTPTransferService, shellExecutionService, string, n, n2});
        UnixHostInstallationService unixHostInstallationService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        SSHCommandService sSHCommandService2 = sSHCommandService;
        SFTPTransferService sFTPTransferService2 = sFTPTransferService;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        String string2 = string;
        int n3 = n;
        int n4 = n2;
        shellCommandBuilder2.shellCommandBuilder = sshCommandService;
        shellCommandBuilder2.sshCommandService = sftpTransferService;
        shellCommandBuilder2.sftpTransferService = shellExecutionService2;
        shellCommandBuilder2.shellExecutionService = sshUsername;
        shellCommandBuilder2.sshUsername = getCurrentRootDeviceTimeout;
        shellCommandBuilder2.getCurrentRootDeviceTimeout = makeRemoteSystemUpdateDirectoryTimeout;
        shellCommandBuilder2.makeRemoteSystemUpdateDirectoryTimeout = n4;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, sSHCommandService, sFTPTransferService, shellExecutionService, string, n, n2}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void install(BuildConfiguration buildConfiguration) throws Exception {
        void installationConfiguration;
        void buildConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"install", (Object[])new Object[]{buildConfiguration});
        UnixHostInstallationService unixHostInstallationService = this;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        InstallationConfiguration installationConfiguration2 = buildConfiguration2.getConfiguration(buildConfiguration3);
        buildConfiguration2.installOnAllHosts((BuildConfiguration)installationConfiguration, installationConfiguration2);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"install", (Object[])new Object[]{buildConfiguration}, null, (long)l);
    }

    protected InstallationConfiguration getConfiguration(BuildConfiguration buildConfiguration) throws FileNotFoundException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getConfiguration", (Object[])new Object[]{buildConfiguration});
        UnixHostInstallationService unixHostInstallationService = this;
        BuildConfiguration buildConfiguration2 = buildConfiguration;
        unixHostInstallationService = (InstallationConfiguration)new Yaml().loadAs((InputStream)new BufferedInputStream(new FileInputStream(buildConfiguration2.getScmConfiguration().getWorkspacePath() + File.separator + "systems" + File.separator + buildConfiguration2.getVariant() + File.separator + "installation")), InstallationConfiguration.class);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getConfiguration", (Object[])new Object[]{buildConfiguration}, (Object)unixHostInstallationService, (long)l);
        return unixHostInstallationService;
    }

    /*
     * WARNING - void declaration
     */
    protected void installOnAllHosts(BuildConfiguration buildConfiguration, InstallationConfiguration installationConfiguration) {
        void installationConfiguration2;
        void buildConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"installOnAllHosts", (Object[])new Object[]{buildConfiguration, installationConfiguration});
        UnixHostInstallationService unixHostInstallationService = this;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        InstallationConfiguration installationConfiguration3 = installationConfiguration;
        installationConfiguration3.getHosts().forEach(arg_0 -> ((UnixHostInstallationService)buildConfiguration2).lambda$installOnAllHosts$0((BuildConfiguration)installationConfiguration2, arg_0));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"installOnAllHosts", (Object[])new Object[]{buildConfiguration, installationConfiguration}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void installOnHost(String string, String string2, String string3) {
        void host;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"installOnHost", (Object[])new Object[]{string, string2, string3});
        UnixHostInstallationService unixHostInstallationService = this;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        if (host == null) {
            throw new IllegalArgumentException("Package path cannot be null.");
        }
        try {
            void installShellCommand;
            void kernelVersion;
            void newRootDevice;
            void rootDirectory;
            void packagePath;
            String string7 = packagePath.getNewRootDevice((String)rootDirectory);
            packagePath.shellExecutionService.run(packagePath.shellCommandBuilder.build().withCommandLine("cat " + (String)host + " | sudo -u " + packagePath.sshUsername + " ssh " + (String)rootDirectory + " sudo dd of=" + string7));
            String string8 = packagePath.getKernelVersion((String)rootDirectory, (String)newRootDevice);
            File file = packagePath.updateBootloaderConfiguration(packagePath.getGrubBootloaderConfiguration((String)rootDirectory), string8, packagePath.getIndex((String)kernelVersion));
            ShellCommand shellCommand = packagePath.shellCommandBuilder.build().withCommandLine("sudo mv /boot/grub/grub.cfg /boot/grub/grub.cfg.$(date +\"%Y.%m.%d.%H.%M.%s.%N\") -f");
            SSHCommand sSHCommand = new SSHCommand(new SSHHost((String)rootDirectory), new SSHUser(packagePath.sshUsername), shellCommand);
            packagePath.sshCommandService.execute(new SSHCommand[]{sSHCommand});
            SFTPTransfer sFTPTransfer = new SFTPTransfer(new SSHHost((String)rootDirectory), new SSHUser(packagePath.sshUsername), installShellCommand.getAbsolutePath(), "/tmp/system-update/grub.cfg");
            packagePath.sftpTransferService.transfer(new SFTPTransfer[]{sFTPTransfer});
            ShellCommand shellCommand2 = packagePath.shellCommandBuilder.build().withCommandLine("sudo mv /tmp/system-update/grub.cfg /boot/grub");
            SSHCommand sSHCommand2 = new SSHCommand(new SSHHost((String)rootDirectory), new SSHUser(packagePath.sshUsername), shellCommand2);
            packagePath.sshCommandService.execute(new SSHCommand[]{sSHCommand2});
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to install on host", exception);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"installOnHost", (Object[])new Object[]{string, string2, string3}, null, (long)l);
    }

    public int getIndex(String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getIndex", (Object[])new Object[]{string});
        UnixHostInstallationService unixHostInstallationService = this;
        String string2 = string;
        int n = Integer.valueOf(string2.substring(string2.length() - 1), string2.length());
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getIndex", (Object[])new Object[]{string}, (Object)n, (long)l);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected String getNewRootDevice(String string) throws Exception {
        void host;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getNewRootDevice", (Object[])new Object[]{string});
        Object object = this;
        String string2 = string;
        String string3 = host.getCurrentRootDevice(string2);
        object = string3.indexOf("2") >= 0 ? string3.replace("2", "1") : (string3.indexOf("3") >= 0 ? string3.replace("3", "1") : string3.replace("1", "2"));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getNewRootDevice", (Object[])new Object[]{string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected String getCurrentRootDevice(String string) throws Exception {
        String string22;
        Object object;
        long l;
        block3: {
            void shellCommand;
            void host;
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getCurrentRootDevice", (Object[])new Object[]{string});
            object = this;
            String string3 = string;
            ShellCommand shellCommand2 = host.shellCommandBuilder.build().withCommandLine("sudo cat /proc/cmdline").withTimeout(host.getCurrentRootDeviceTimeout);
            SSHCommand sSHCommand = new SSHCommand(new SSHHost((String)shellCommand), new SSHUser(host.sshUsername), shellCommand2);
            host.sshCommandService.execute(new SSHCommand[]{sSHCommand});
            for (String string4 : ((CommandOutput)sSHCommand.getShellCommand().getOutputs().get(0)).getOutput().split("\n")) {
                for (String string22 : string4.split(" ")) {
                    if (string22 == null || string22.indexOf("root=") != 0) {
                        continue;
                    }
                    break block3;
                }
            }
            throw new IllegalStateException("Unable to get current root.");
        }
        object = string22.split("root=")[1];
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getCurrentRootDevice", (Object[])new Object[]{string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected File getGrubBootloaderConfiguration(String string) throws Exception {
        void sftpTransfer;
        void host;
        void tempFile;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getGrubBootloaderConfiguration", (Object[])new Object[]{string});
        UnixHostInstallationService unixHostInstallationService = this;
        String string2 = string;
        File file = File.createTempFile("grub", "cfg");
        SFTPTransfer sFTPTransfer = new SFTPTransfer(new SSHHost((String)tempFile), new SSHUser(host.sshUsername), file.getAbsolutePath(), "/boot/grub/grub.cfg");
        sFTPTransfer.setUpload(false);
        host.sftpTransferService.transfer(new SFTPTransfer[]{sFTPTransfer});
        unixHostInstallationService = sftpTransfer;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getGrubBootloaderConfiguration", (Object[])new Object[]{string}, (Object)unixHostInstallationService, (long)l);
        return unixHostInstallationService;
    }

    /*
     * WARNING - void declaration
     */
    public File updateBootloaderConfiguration(File file, String string, int n) throws IOException {
        void index;
        void tempFile;
        void edit;
        void i;
        int start;
        void startOfFirstMenuItem;
        void kernelVersion;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"updateBootloaderConfiguration", (Object[])new Object[]{file, string, n});
        Object object = this;
        File file2 = file;
        String string2 = string;
        int n2 = n;
        List list = IOUtils.readLines((InputStream)new BufferedInputStream(new FileInputStream((File)kernelVersion)), (String)"UTF-8");
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n4 = 0;
        for (String string3 : startOfFirstMenuItem) {
            boolean end;
            String string4 = string3.trim();
            if (string4.indexOf("menuentry") == 0) {
                void lines;
                if (start < 0) {
                    start = n4;
                }
                if (string4.indexOf("funtoo." + (int)lines) >= 0) {
                    end = true;
                    i.add(string4);
                    continue;
                }
            }
            if (end) {
                boolean output;
                if (!output) {
                    i.add(string4);
                    if (string4.indexOf("}") >= 0) {
                        output = true;
                    }
                } else {
                    edit.add(string4);
                }
            } else {
                edit.add(string4);
            }
            ++n4;
        }
        File file3 = File.createTempFile("grub", "cfg");
        FileUtils.write((File)file3, (CharSequence)tempFile.updateBootloader((String)index, (List<String>)i, (List<String>)edit, start), (String)"UTF-8");
        object = file3;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"updateBootloaderConfiguration", (Object[])new Object[]{file, string, n}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected String updateBootloader(String string, List<String> list, List<String> list2, int n) {
        void start;
        void output;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"updateBootloader", (Object[])new Object[]{string, list, list2, n});
        Object object = this;
        String string2 = string;
        List<String> list3 = list;
        List<String> list4 = list2;
        int n2 = n;
        int n3 = 0;
        for (String string3 : output) {
            void i;
            void arguments;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (String string4 : arguments.split(" ")) {
                void edit;
                if (string4.indexOf("/kernel") >= 0) {
                    arrayList.add("/kernel-" + (String)edit);
                    continue;
                }
                if (string4.indexOf("/initramfs") >= 0) {
                    arrayList.add("/initramfs-" + (String)edit);
                    continue;
                }
                arrayList.add(string4);
            }
            start.add((int)(i + n3), String.join((CharSequence)" ", arrayList));
            ++n3;
        }
        object = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)start);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"updateBootloader", (Object[])new Object[]{string, list, list2, n}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected String getKernelVersion(String string, String string2) throws Exception {
        void systemMap;
        void rootDirectory;
        void init;
        void kernelVersion;
        void host;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getKernelVersion", (Object[])new Object[]{string, string2});
        UnixHostInstallationService unixHostInstallationService = this;
        String string3 = string;
        String string4 = string2;
        File file = new File(string4 + "/boot");
        File file2 = file.listFiles(new KernelFilenameFilter((UnixHostInstallationService)host))[0];
        String string5 = file2.getName().substring(7).trim();
        File file3 = new File(kernelVersion.getParentFile().getAbsolutePath() + File.separator + "initramfs-" + string5);
        File file4 = new File(kernelVersion.getParentFile().getAbsolutePath() + File.separator + "System.map-" + (String)init);
        host.sshCommandService.execute(new SSHCommand[]{new SSHCommand(new SSHHost((String)rootDirectory), new SSHUser(host.sshUsername), host.shellCommandBuilder.build().withCommandLine("mkdir -p /tmp/system-update").withTimeout(host.makeRemoteSystemUpdateDirectoryTimeout))});
        host.sftpTransferService.transfer(new SFTPTransfer[]{new SFTPTransfer(new SSHHost((String)rootDirectory), new SSHUser(host.sshUsername), kernelVersion.getAbsolutePath(), "/tmp/system-update")});
        host.sftpTransferService.transfer(new SFTPTransfer[]{new SFTPTransfer(new SSHHost((String)rootDirectory), new SSHUser(host.sshUsername), systemMap.getAbsolutePath(), "/tmp/system-update")});
        host.sftpTransferService.transfer(new SFTPTransfer[]{new SFTPTransfer(new SSHHost((String)rootDirectory), new SSHUser(host.sshUsername), file4.getAbsolutePath(), "/tmp/system-update")});
        ShellCommand shellCommand = host.shellCommandBuilder.build().withCommandLine("sudo mv /tmp/system-update/{kernel-" + (String)init + ",initramfs-" + (String)init + ",System.map-" + (String)init + "} /boot").withTimeout(5);
        SSHCommand sSHCommand = new SSHCommand(new SSHHost((String)rootDirectory), new SSHUser(host.sshUsername), shellCommand);
        host.sshCommandService.execute(new SSHCommand[]{sSHCommand});
        unixHostInstallationService = init;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService", (String)"getKernelVersion", (Object[])new Object[]{string, string2}, (Object)unixHostInstallationService, (long)l);
        return unixHostInstallationService;
    }

    private /* synthetic */ void lambda$installOnAllHosts$0(BuildConfiguration buildConfiguration, String host) {
        this.installOnHost(buildConfiguration.getPackagePath(), host, buildConfiguration.getRootDirectory());
    }

    class KernelFilenameFilter
    implements FilenameFilter {
        final /* synthetic */ UnixHostInstallationService this$0;

        /*
         * WARNING - void declaration
         */
        KernelFilenameFilter(UnixHostInstallationService unixHostInstallationService) {
            void this$0;
            UnixHostInstallationService unixHostInstallationService2;
            long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService$KernelFilenameFilter", (String)"<init>", (Object[])new Object[]{unixHostInstallationService});
            KernelFilenameFilter kernelFilenameFilter = this;
            this$0.this$0 = unixHostInstallationService2 = unixHostInstallationService;
            MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService$KernelFilenameFilter", (String)"<init>", (Object[])new Object[]{unixHostInstallationService}, null, (long)l);
        }

        @Override
        public boolean accept(File file, String string) {
            long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService$KernelFilenameFilter", (String)"accept", (Object[])new Object[]{file, string});
            KernelFilenameFilter kernelFilenameFilter = this;
            File file2 = file;
            String string2 = string;
            boolean bl = string2.startsWith("kernel");
            MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.installation.UnixHostInstallationService$KernelFilenameFilter", (String)"accept", (Object[])new Object[]{file, string}, (Object)bl, (long)l);
            return bl;
        }
    }
}

