/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.MountPointConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.module.AbstractCollectionModule;
import io.github.qsy7.linux.builder.impl.service.util.configuration.YamlConfigurer;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.model.MountPoint;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

@ModuleSupports(distribution=DistributionConfiguration.Linux, configurer=YamlConfigurer.class, configurationClass=MountPointConfiguration.class)
public class FstabModule
extends AbstractCollectionModule<MountPointConfiguration> {
    public static final String FSTAB_TEMPLATE = "%s %s %s %s 0 0 # %s\n";

    /*
     * WARNING - void declaration
     */
    @Inject
    public FstabModule(BuildService buildService, BuildConfiguration buildConfiguration, DistributionConfiguration distributionConfiguration) {
        void distributionConfiguration2;
        void buildConfiguration2;
        void buildService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"<init>", (Object[])new Object[]{buildService, buildConfiguration, distributionConfiguration});
        FstabModule fstabModule = this;
        BuildService buildService3 = buildService;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        super((BuildService)buildConfiguration2, (BuildConfiguration)distributionConfiguration2, distributionConfiguration3);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"<init>", (Object[])new Object[]{buildService, buildConfiguration, distributionConfiguration}, null, (long)l);
    }

    public void document() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"document", (Object[])new Object[0]);
        FstabModule fstabModule = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"document", (Object[])new Object[0], null, (long)l);
    }

    protected File getFstabFile() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"getFstabFile", (Object[])new Object[0]);
        Object object = this;
        object = new File(((FstabModule)object).buildConfiguration.getRootDirectory() + File.separator + "etc/fstab");
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"getFstabFile", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doRun(MountPointConfiguration mountPointConfiguration) throws IOException {
        void mountPoint;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"doRun", (Object[])new Object[]{mountPointConfiguration});
        FstabModule fstabModule = this;
        MountPointConfiguration mountPointConfiguration2 = mountPointConfiguration;
        FileUtils.write((File)mountPoint.getFstabFile(), (CharSequence)mountPoint.getFstabLine(mountPointConfiguration2), (String)"UTF-8", (boolean)true);
        new File(mountPoint.buildConfiguration.getRootDirectory() + mountPointConfiguration2.getMountPoint()).mkdirs();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"doRun", (Object[])new Object[]{mountPointConfiguration}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public String getFstabLine(MountPointConfiguration mountPointConfiguration) {
        void mountPoint;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"getFstabLine", (Object[])new Object[]{mountPointConfiguration});
        Object object = this;
        MountPointConfiguration mountPointConfiguration2 = mountPointConfiguration;
        object = String.format(FSTAB_TEMPLATE, mountPointConfiguration2.getDevice(), mountPointConfiguration2.getMountPoint(), mountPointConfiguration2.getVfsType().getType(), FstabModule.getOptions((MountPoint)mountPointConfiguration2), mountPoint.patchName);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"getFstabLine", (Object[])new Object[]{mountPointConfiguration}, (Object)object, (long)l);
        return object;
    }

    public static String getOptions(MountPoint mountPoint) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"getOptions", (Object[])new Object[]{mountPoint});
        Object object = mountPoint;
        object = object.getOptions() != null && !object.getOptions().isEmpty() ? object.getOptions() + ",defaults" : "defaults";
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.FstabModule", (String)"getOptions", (Object[])new Object[]{mountPoint}, (Object)object, (long)l);
        return object;
    }
}

