/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.module.funtoo;

import io.github.qsy7.download.api.model.Download;
import io.github.qsy7.download.api.service.DownloadService;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.Stage3Configuration;
import io.github.qsy7.linux.builder.api.model.enumeration.InstructionSet;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.module.AbstractSingleModule;
import io.github.qsy7.linux.builder.impl.service.util.FuntooStageUriUtil;
import io.github.qsy7.linux.builder.impl.service.util.PortageUtil;
import io.github.qsy7.linux.builder.impl.service.util.configuration.YamlConfigurer;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

@ModuleSupports(distribution=DistributionConfiguration.Gentoo, configurer=YamlConfigurer.class, configurationClass=Stage3Configuration.class)
public class Stage3Module
extends AbstractSingleModule<Stage3Configuration> {
    protected String stage3Uri;
    protected String stage3ChecksumUri;
    protected final ShellCommandBuilder shellCommandBuilder;
    protected final DownloadService downloadService;
    protected final ShellExecutionService shellExecutionService;

    /*
     * WARNING - void declaration
     */
    @Inject
    public Stage3Module(BuildService buildService, BuildConfiguration buildConfiguration, DistributionConfiguration distributionConfiguration, ShellCommandBuilder shellCommandBuilder, DownloadService downloadService, ShellExecutionService shellExecutionService) {
        void shellExecutionService2;
        void downloadService2;
        void shellCommandBuilder2;
        void distributionConfiguration2;
        void buildConfiguration2;
        void buildService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"<init>", (Object[])new Object[]{buildService, buildConfiguration, distributionConfiguration, shellCommandBuilder, downloadService, shellExecutionService});
        Stage3Module stage3Module = this;
        BuildService buildService3 = buildService;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        DownloadService downloadService3 = downloadService;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        super((BuildService)buildConfiguration2, (BuildConfiguration)distributionConfiguration2, (DistributionConfiguration)shellCommandBuilder2);
        buildService2.shellCommandBuilder = downloadService2;
        buildService2.downloadService = shellExecutionService2;
        buildService2.shellExecutionService = shellExecutionService3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"<init>", (Object[])new Object[]{buildService, buildConfiguration, distributionConfiguration, shellCommandBuilder, downloadService, shellExecutionService}, null, (long)l);
    }

    @Override
    public void onSetup() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"onSetup", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        super.onSetup();
        stage3Module.stage3Uri = FuntooStageUriUtil.getStageUri((Stage3Configuration)stage3Module.configuration);
        stage3Module.stage3ChecksumUri = FuntooStageUriUtil.getStage3ChecksumUri(stage3Module.stage3Uri);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"onSetup", (Object[])new Object[0], null, (long)l);
    }

    public void document() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"document", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"document", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void doRun() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"doRun", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        stage3Module.setupRoot();
        stage3Module.configureMakeConf();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"doRun", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setupRoot() throws Exception {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"setupRoot", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        if (stage3Module.isChrootEnvironmentSetup()) {
            bl = false;
        } else {
            void checksumFile;
            File file = stage3Module.downloadService.download(new Download(stage3Module.stage3ChecksumUri, null, Stage3Module.getStageFilename((Stage3Configuration)stage3Module.configuration, stage3Module.stage3ChecksumUri)));
            File file2 = checksumFile.downloadService.download(new Download(checksumFile.stage3Uri, null, Stage3Module.getStageFilename((Stage3Configuration)checksumFile.configuration, checksumFile.stage3Uri)), file);
            checksumFile.extractStage3File(file2);
            checksumFile.removeVarGit();
            checksumFile.removeUsrSrc();
            bl = true;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"setupRoot", (Object[])new Object[0], (Object)bl2, (long)l);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getStageFilename(Stage3Configuration stage3Configuration, String string) {
        void stageUri;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getStageFilename", (Object[])new Object[]{stage3Configuration, string});
        Object object = stage3Configuration;
        String string2 = string;
        object = String.format("%s.%s.%s.%s", stageUri.getBuild(), stageUri.getSubArchitecture().getArchitecture().getName(), stageUri.getSubArchitecture().getName(), Download.getFilename((String)string2));
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getStageFilename", (Object[])new Object[]{stage3Configuration, string}, (Object)object, (long)l);
        return object;
    }

    protected boolean isChrootEnvironmentSetup() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"isChrootEnvironmentSetup", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        boolean bl = new File(stage3Module.buildConfiguration.getRootDirectory() + "/bin/bash").exists();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"isChrootEnvironmentSetup", (Object[])new Object[0], (Object)bl, (long)l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void extractStage3File(File file) throws Exception {
        void root;
        void stage3File;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"extractStage3File", (Object[])new Object[]{file});
        Stage3Module stage3Module = this;
        File file2 = file;
        File file3 = new File(stage3File.buildConfiguration.getRootDirectory());
        if (!file3.exists()) {
            file3.mkdirs();
        }
        stage3File.shellExecutionService.run(stage3File.shellCommandBuilder.build().withCommandLine("tar xpf " + root.getAbsolutePath() + " -C " + stage3File.buildConfiguration.getRootDirectory()));
        File file4 = new File(stage3File.buildConfiguration.getRootDirectory() + "/var/git/meta-repo");
        stage3File.shellExecutionService.run(stage3File.shellCommandBuilder.build().withCommandLine("rm -rf " + file4.getAbsolutePath()));
        file4.mkdirs();
        File file5 = new File(stage3File.buildConfiguration.getRootDirectory() + "/src/src");
        stage3File.shellExecutionService.run(stage3File.shellCommandBuilder.build().withCommandLine("rm -rf " + file5.getAbsolutePath()));
        file5.mkdirs();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"extractStage3File", (Object[])new Object[]{file}, null, (long)l);
    }

    protected void configureMakeConf() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"configureMakeConf", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        FileUtils.write((File)stage3Module.getPortageConfigurationFile(), (CharSequence)stage3Module.getContents(), (String)"UTF-8", (boolean)false);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"configureMakeConf", (Object[])new Object[0], null, (long)l);
    }

    protected File getPortageConfigurationFile() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getPortageConfigurationFile", (Object[])new Object[0]);
        Object object = this;
        object = new File(((Stage3Module)object).buildConfiguration.getRootDirectory() + File.separator + "etc/portage/make.conf");
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getPortageConfigurationFile", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected String getContents() {
        void buffer;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getContents", (Object[])new Object[0]);
        Object object = this;
        StringBuilder stringBuilder = new StringBuilder();
        PortageUtil.append(stringBuilder, "http_proxy", System.getenv("http_proxy"));
        stringBuilder.append("\n");
        PortageUtil.append(stringBuilder, "CHOST", ((Stage3Configuration)buffer.configuration).getSubArchitecture().getPlatform().getGccHost());
        PortageUtil.append(stringBuilder, "CFLAGS", ((Stage3Configuration)buffer.configuration).getSubArchitecture().getCflags());
        PortageUtil.append(stringBuilder, "CXXFLAGS", "${CFLAGS}");
        PortageUtil.append(stringBuilder, "CPU_FLAGS_X86", InstructionSet.getCpuFlags((InstructionSet[])((Stage3Configuration)buffer.configuration).getSubArchitecture().getInstructionSets()));
        PortageUtil.append(stringBuilder, "MAKEOPTS", Stage3Module.getMakeOpts());
        if (((Stage3Configuration)buffer.configuration).getMirrors() != null) {
            stringBuilder.append("GENTOO_MIRRORS=\"" + String.join((CharSequence)" ", ((Stage3Configuration)buffer.configuration).getMirrors()) + "\"\n");
        }
        stringBuilder.append("\n");
        object = stringBuilder.toString();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getContents", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    private static final String getMakeOpts() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getMakeOpts", (Object[])new Object[0]);
        int n = Runtime.getRuntime().availableProcessors();
        String string = "-j" + (n + 1);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"getMakeOpts", (Object[])new Object[0], (Object)string, (long)l);
        return string;
    }

    protected void removeVarGit() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"removeVarGit", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        FileUtils.deleteDirectory((File)new File(stage3Module.buildConfiguration.getRootDirectory() + "/var/git"));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"removeVarGit", (Object[])new Object[0], null, (long)l);
    }

    protected void removeUsrSrc() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"removeUsrSrc", (Object[])new Object[0]);
        Stage3Module stage3Module = this;
        FileUtils.deleteDirectory((File)new File(stage3Module.buildConfiguration.getRootDirectory() + "/usr/src"));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.funtoo.Stage3Module", (String)"removeUsrSrc", (Object[])new Object[0], null, (long)l);
    }
}

