/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.data.pipe.impl.periodic;

import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.github.qsy7.data.pipe.api.source.Source;
import io.github.qsy7.data.pipe.impl.AbstractSource;
import io.github.qsy7.data.pipe.impl.QueueIterator;
import io.github.qsy7.data.pipe.impl.periodic.PeriodicRecord;
import io.github.qsy7.data.pipe.impl.periodic.PeriodicSourceConfiguration;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import javax.enterprise.util.AnnotationLiteral;

public class PeriodicSource<SourceRecordType extends Serializable>
extends AbstractSource<PeriodicRecord<SourceRecordType>, PeriodicSourceConfiguration>
implements Runnable {
    protected final PriorityBlockingQueue<PeriodicRecord<SourceRecordType>> queue;
    protected final QueueIterator iterator;
    protected final ListeningScheduledExecutorService executorService;
    protected ListenableScheduledFuture future;
    protected Source source;

    /*
     * WARNING - void declaration
     */
    protected PeriodicSource(ListeningScheduledExecutorService listeningScheduledExecutorService) {
        void executorService;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"<init>", (Object[])new Object[]{listeningScheduledExecutorService});
        PeriodicSource periodicSource = this;
        ListeningScheduledExecutorService listeningScheduledExecutorService2 = listeningScheduledExecutorService;
        executorService.queue = new PriorityBlockingQueue();
        executorService.executorService = listeningScheduledExecutorService2;
        executorService.iterator = new QueueIterator(executorService.queue);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"<init>", (Object[])new Object[]{listeningScheduledExecutorService}, null, (long)l);
    }

    public Iterator<PeriodicRecord<SourceRecordType>> iterator() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"iterator", (Object[])new Object[0]);
        Object object = this;
        object = ((PeriodicSource)object).iterator;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"iterator", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected List<SourceRecordType> doRunOnce() {
        void sourceIterator;
        void data;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doRunOnce", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = data.source.iterator();
        while (iterator.hasNext()) {
            sourceIterator.add((Serializable)iterator.next());
        }
        periodicSource = sourceIterator;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doRunOnce", (Object[])new Object[0], (Object)periodicSource, (long)l);
        return periodicSource;
    }

    @Override
    protected void doConfigure() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doConfigure", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        periodicSource.source = (Source)ApplicationHelper.getApplicationInstance().getInjector().getInstance(((PeriodicSourceConfiguration)periodicSource.sourceConfiguration).getSourceConfiguration().getSourceClass(), new AnnotationLiteral[0]);
        periodicSource.future = periodicSource.executorService.scheduleWithFixedDelay((Runnable)periodicSource, 0L, ((PeriodicSourceConfiguration)periodicSource.sourceConfiguration).getInterval(), ((PeriodicSourceConfiguration)periodicSource.sourceConfiguration).getTimeUnit());
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doConfigure", (Object[])new Object[0], null, (long)l);
    }

    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"close", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        periodicSource.future.cancel(true);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void run() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"run", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        periodicSource.queue.put(new PeriodicRecord<SourceRecordType>(LocalDateTime.now(), periodicSource.doRunOnce()));
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"run", (Object[])new Object[0], null, (long)l);
    }
}

