/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.data.pipe.impl.periodic;

import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.github.qsy7.data.pipe.api.source.Source;
import io.github.qsy7.data.pipe.impl.AbstractSource;
import io.github.qsy7.data.pipe.impl.QueueIterator;
import io.github.qsy7.data.pipe.impl.periodic.PeriodicRecord;
import io.github.qsy7.data.pipe.impl.periodic.PeriodicSourceConfiguration;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class PeriodicSource<SourceRecordType extends Serializable>
extends AbstractSource<PeriodicRecord<SourceRecordType>, PeriodicSourceConfiguration>
implements Runnable {
    protected final PriorityBlockingQueue<PeriodicRecord<SourceRecordType>> queue;
    protected final QueueIterator iterator;
    protected final ListeningScheduledExecutorService executorService;
    protected ListenableScheduledFuture future;
    protected Source source;

    /*
     * WARNING - void declaration
     */
    protected PeriodicSource(ListeningScheduledExecutorService listeningScheduledExecutorService) {
        void executorService;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"<init>", (Object[])new Object[]{listeningScheduledExecutorService});
        PeriodicSource periodicSource = this;
        ListeningScheduledExecutorService listeningScheduledExecutorService2 = listeningScheduledExecutorService;
        periodicSource.queue = new PriorityBlockingQueue();
        periodicSource.executorService = executorService;
        periodicSource.iterator = new QueueIterator(periodicSource.queue);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"<init>", (Object[])new Object[]{listeningScheduledExecutorService}, null, (long)l);
    }

    public Iterator<PeriodicRecord<SourceRecordType>> iterator() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"iterator", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        Object object = periodicSource;
        try {
            object = ((PeriodicSource)object).iterator;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    protected List<SourceRecordType> doRunOnce() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doRunOnce", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        Object object = periodicSource;
        try {
            ArrayList<Serializable> data = new ArrayList<Serializable>();
            Iterator sourceIterator = ((PeriodicSource)object).source.iterator();
            while (sourceIterator.hasNext()) {
                data.add((Serializable)sourceIterator.next());
            }
            object = data;
            return object;
        }
        finally {
            Object var5_4 = null;
        }
    }

    @Override
    protected void doConfigure() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doConfigure", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        PeriodicSource periodicSource2 = periodicSource;
        try {
            periodicSource2.source = (Source)ApplicationHelper.getApplicationInstance().getInjector().getInstance(((PeriodicSourceConfiguration)periodicSource2.sourceConfiguration).getSourceConfiguration().getSourceClass(), new AnnotationLiteral[0]);
            periodicSource2.future = periodicSource2.executorService.scheduleWithFixedDelay((Runnable)periodicSource2, 0L, ((PeriodicSourceConfiguration)periodicSource2.sourceConfiguration).getInterval(), ((PeriodicSourceConfiguration)periodicSource2.sourceConfiguration).getTimeUnit());
            periodicSource2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (periodicSource2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doConfigure", (Object[])new Object[0], (Throwable)((Object)periodicSource2));
        }
        if (periodicSource2 != null) {
            throw periodicSource2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"doConfigure", (Object[])new Object[0], null, (long)l);
    }

    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"close", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        PeriodicSource periodicSource2 = periodicSource;
        try {
            periodicSource2.future.cancel(true);
            periodicSource2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (periodicSource2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"close", (Object[])new Object[0], (Throwable)((Object)periodicSource2));
        }
        if (periodicSource2 != null) {
            throw periodicSource2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void run() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"run", (Object[])new Object[0]);
        PeriodicSource periodicSource = this;
        PeriodicSource periodicSource2 = periodicSource;
        try {
            periodicSource2.queue.put(new PeriodicRecord<SourceRecordType>(LocalDateTime.now(), periodicSource2.doRunOnce()));
            periodicSource2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (periodicSource2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"run", (Object[])new Object[0], (Throwable)((Object)periodicSource2));
        }
        if (periodicSource2 != null) {
            throw periodicSource2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.data.pipe.impl.periodic.PeriodicSource", (String)"run", (Object[])new Object[0], null, (long)l);
    }
}

