package io.github.qsy7.data.pipe.impl;

import io.github.qsy7.data.pipe.api.transformation.AbstractTransformationConfiguration;
import io.github.qsy7.data.pipe.api.transformation.Transformation;

public abstract class AbstractTransformation<
        SourceRecordType,
        SinkRecordType,
        TransformationConfigurationType extends AbstractTransformationConfiguration>
    implements Transformation<SourceRecordType, SinkRecordType, TransformationConfigurationType> {
  protected TransformationConfigurationType transformationConfiguration;

  @Override
  public void configure(TransformationConfigurationType transformationConfiguration) {
    this.transformationConfiguration = transformationConfiguration;
    doConfigure();
  }

  protected abstract void doConfigure();
}
