/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.print.impl;

import io.github.qsy7.datastore.api.model.entity.Entity;
import io.github.qsy7.datastore.api.repository.QueryConfiguration;
import io.github.qsy7.datastore.api.repository.Repository;
import io.github.qsy7.file.api.service.FileStorageService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.print.api.service.FindPrinterByLocationAndPrinterType;
import io.github.qsy7.print.api.service.PrinterService;
import io.github.qsy7.print.model.PrintJob;
import io.github.qsy7.print.model.PrintRequest;
import io.github.qsy7.print.model.Printer;
import jakarta.inject.Provider;
import javax.transaction.Transactional;

public abstract class AbstractPrinterService
implements PrinterService {
    protected final boolean isNooperation;
    protected final FileStorageService fileStorageService;
    protected final Provider<Repository> repositoryProvider;

    /*
     * WARNING - void declaration
     */
    protected AbstractPrinterService(boolean bl, FileStorageService fileStorageService, Provider<Repository> provider) {
        void repositoryProvider;
        void fileStorageService2;
        void isNooperation;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.print.impl.AbstractPrinterService", (String)"<init>", (Object[])new Object[]{bl, fileStorageService, provider});
        AbstractPrinterService abstractPrinterService = this;
        boolean bl2 = bl;
        FileStorageService fileStorageService3 = fileStorageService;
        Provider<Repository> provider2 = provider;
        abstractPrinterService.isNooperation = isNooperation;
        abstractPrinterService.fileStorageService = fileStorageService2;
        abstractPrinterService.repositoryProvider = repositoryProvider;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.print.impl.AbstractPrinterService", (String)"<init>", (Object[])new Object[]{bl, fileStorageService, provider}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public PrintJob print(PrintRequest printRequest) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.print.impl.AbstractPrinterService", (String)"print", (Object[])new Object[]{printRequest});
        AbstractPrinterService abstractPrinterService = this;
        PrintRequest printRequest2 = printRequest;
        AbstractPrinterService abstractPrinterService2 = abstractPrinterService;
        PrintRequest printRequest3 = printRequest2;
        try {
            void printRequest4;
            Repository entityRepository = (Repository)abstractPrinterService2.repositoryProvider.get();
            if (printRequest4.getId() == null) {
                entityRepository.create((Entity)printRequest4);
            }
            PrintJob printJob = new PrintJob(abstractPrinterService2.getPrinter((PrintRequest)printRequest4), (PrintRequest)printRequest4);
            entityRepository.create((Entity)printJob);
            if (!abstractPrinterService2.isNooperation) {
                abstractPrinterService2.fileStorageService.get(printRequest4.getFile());
                abstractPrinterService2.doPrint(printJob);
            }
            abstractPrinterService2 = (PrintJob)entityRepository.create((Entity)printJob);
            return abstractPrinterService2;
        }
        finally {
            printRequest3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Printer getPrinter(PrintRequest printRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.print.impl.AbstractPrinterService", (String)"getPrinter", (Object[])new Object[]{printRequest});
        AbstractPrinterService abstractPrinterService = this;
        PrintRequest printRequest2 = printRequest;
        AbstractPrinterService abstractPrinterService2 = abstractPrinterService;
        PrintRequest printRequest3 = printRequest2;
        try {
            void printRequest4;
            if (printRequest4.getLocation() != null) {
                throw new IllegalStateException("No printer chosen");
            }
            abstractPrinterService2 = (Printer)((Repository)abstractPrinterService2.repositoryProvider.get()).query((QueryConfiguration)new FindPrinterByLocationAndPrinterType(0, 1, printRequest4.getLocation(), null));
            return abstractPrinterService2;
        }
        finally {
            printRequest3 = null;
        }
    }

    protected abstract void doPrint(PrintJob var1) throws Exception;
}

