/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.api.enumeration;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import java.util.Arrays;

public enum ActionType {
    Cancel("Job Executions in one of these states may be cancelled.", new ExecutionState[]{ExecutionState.Queued, ExecutionState.Assigned, ExecutionState.Scheduled, ExecutionState.Running}),
    Assign("Job Executions in one of these states may be assigned to a worker", new ExecutionState[]{ExecutionState.Queued}),
    RecurringAssign("Job Executions in one of these states may be assigned to a worker (for recurring jobs only)", new ExecutionState[]{ExecutionState.Completed, ExecutionState.Cancelled, ExecutionState.Aborted, ExecutionState.Exception}),
    Aborted("Job Executions in one of these states may be aborted, provided the current time is > the timeoutDateTime for the execution", new ExecutionState[]{ExecutionState.Queued, ExecutionState.Assigned, ExecutionState.Scheduled, ExecutionState.Running});

    private final String description;
    private final ExecutionState[] supportedExecutionStates;

    /*
     * WARNING - void declaration
     */
    public boolean isSupported(ExecutionState executionState) {
        void executionState2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"isSupported", (Object[])new Object[]{executionState});
        ActionType actionType = this;
        ExecutionState executionState3 = executionState;
        boolean bl = Arrays.stream(executionState2.supportedExecutionStates).filter(supportedExecutionState -> supportedExecutionState.equals((Object)executionState3)).count() > 0L;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"isSupported", (Object[])new Object[]{executionState}, (Object)bl, (long)l);
        return bl;
    }

    public String getDescription() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"getDescription", (Object[])new Object[0]);
        Object object = this;
        object = object.description;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"getDescription", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public ExecutionState[] getSupportedExecutionStates() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"getSupportedExecutionStates", (Object[])new Object[0]);
        ExecutionState[] executionStateArray = this;
        executionStateArray = executionStateArray.supportedExecutionStates;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"getSupportedExecutionStates", (Object[])new Object[0], (Object)executionStateArray, (long)l);
        return executionStateArray;
    }

    /*
     * WARNING - void declaration
     */
    private ActionType(String string2, ExecutionState[] executionStateArray) {
        void supportedExecutionStates;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"<init>", (Object[])new Object[]{string, n, string2, executionStateArray});
        ActionType actionType = this;
        String string3 = string;
        int n2 = n;
        String string4 = string2;
        ExecutionState[] executionStateArray2 = executionStateArray;
        actionType.description = supportedExecutionStates;
        actionType.supportedExecutionStates = executionStateArray2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"<init>", (Object[])new Object[]{string, n, string2, executionStateArray}, null, (long)l);
    }
}

