/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.api.model;

import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.enumeration.QueueState;
import io.github.qsy7.queue.api.model.JobExecution;
import io.github.qsy7.queue.api.model.Queue;
import io.github.qsy7.queue.api.model.Unqueueable;
import io.github.qsy7.queue.api.model.Worker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Inheritance(strategy=InheritanceType.JOINED)
@Entity
public class AbstractQueued
extends AbstractEntity
implements Unqueueable {
    protected transient boolean system;
    @Column(nullable=false)
    protected Class jobExecutorClass;
    @ManyToOne(optional=false)
    @JoinColumn(nullable=false, updatable=false)
    protected Worker originatingWorker;
    @Column(nullable=false, updatable=false)
    protected LocalDateTime queueDateTime;
    @OneToMany(mappedBy="queued")
    protected List<JobExecution> jobExecutions;
    @ManyToOne
    @JoinColumn
    protected JobExecution currentJobExecution;
    @ManyToOne
    @JoinColumn(updatable=false)
    protected Queue queue;
    @Enumerated
    @Column
    protected QueueState queueState;

    public AbstractQueued() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"<init>", (Object[])new Object[0]);
        AbstractQueued abstractQueued = this;
        abstractQueued.jobExecutions = new ArrayList<JobExecution>();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"<init>", (Object[])new Object[0], null, (long)l);
    }

    public boolean isSystem() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"isSystem", (Object[])new Object[0]);
        AbstractQueued abstractQueued = this;
        boolean bl = abstractQueued.system;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"isSystem", (Object[])new Object[0], (Object)bl, (long)l);
        return bl;
    }

    public Class getJobExecutorClass() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getJobExecutorClass", (Object[])new Object[0]);
        Object object = this;
        object = ((AbstractQueued)object).jobExecutorClass;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getJobExecutorClass", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public Worker getOriginatingWorker() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getOriginatingWorker", (Object[])new Object[0]);
        Object object = this;
        object = object.originatingWorker;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getOriginatingWorker", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public LocalDateTime getQueueDateTime() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getQueueDateTime", (Object[])new Object[0]);
        Object object = this;
        object = ((AbstractQueued)object).queueDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getQueueDateTime", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public List<JobExecution> getJobExecutions() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getJobExecutions", (Object[])new Object[0]);
        Object object = this;
        object = ((AbstractQueued)object).jobExecutions;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getJobExecutions", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public JobExecution getCurrentJobExecution() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getCurrentJobExecution", (Object[])new Object[0]);
        AbstractEntity abstractEntity = this;
        abstractEntity = abstractEntity.currentJobExecution;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getCurrentJobExecution", (Object[])new Object[0], (Object)abstractEntity, (long)l);
        return abstractEntity;
    }

    public Queue getQueue() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getQueue", (Object[])new Object[0]);
        Unqueueable unqueueable = this;
        unqueueable = unqueueable.queue;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getQueue", (Object[])new Object[0], (Object)unqueueable, (long)l);
        return unqueueable;
    }

    public QueueState getQueueState() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getQueueState", (Object[])new Object[0]);
        Object object = this;
        object = object.queueState;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"getQueueState", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public void setSystem(boolean bl) {
        boolean bl2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setSystem", (Object[])new Object[]{bl});
        AbstractQueued abstractQueued = this;
        system.system = bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setSystem", (Object[])new Object[]{bl}, null, (long)l);
    }

    public void setJobExecutorClass(Class clazz) {
        Class clazz2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setJobExecutorClass", (Object[])new Object[]{clazz});
        AbstractQueued abstractQueued = this;
        jobExecutorClass.jobExecutorClass = clazz2 = clazz;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setJobExecutorClass", (Object[])new Object[]{clazz}, null, (long)l);
    }

    public void setOriginatingWorker(Worker worker) {
        Worker worker2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setOriginatingWorker", (Object[])new Object[]{worker});
        AbstractQueued abstractQueued = this;
        originatingWorker.originatingWorker = worker2 = worker;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setOriginatingWorker", (Object[])new Object[]{worker}, null, (long)l);
    }

    public void setQueueDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setQueueDateTime", (Object[])new Object[]{localDateTime});
        AbstractQueued abstractQueued = this;
        queueDateTime.queueDateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setQueueDateTime", (Object[])new Object[]{localDateTime}, null, (long)l);
    }

    public void setJobExecutions(List<JobExecution> list) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setJobExecutions", (Object[])new Object[]{list});
        AbstractQueued abstractQueued = this;
        List<JobExecution> list2 = list;
        jobExecutions.jobExecutions = list2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setJobExecutions", (Object[])new Object[]{list}, null, (long)l);
    }

    public void setCurrentJobExecution(JobExecution jobExecution) {
        JobExecution jobExecution2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setCurrentJobExecution", (Object[])new Object[]{jobExecution});
        AbstractQueued abstractQueued = this;
        currentJobExecution.currentJobExecution = jobExecution2 = jobExecution;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setCurrentJobExecution", (Object[])new Object[]{jobExecution}, null, (long)l);
    }

    public void setQueue(Queue queue) {
        Queue queue2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setQueue", (Object[])new Object[]{queue});
        AbstractQueued abstractQueued = this;
        queue.queue = queue2 = queue;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setQueue", (Object[])new Object[]{queue}, null, (long)l);
    }

    public void setQueueState(QueueState queueState) {
        QueueState queueState2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setQueueState", (Object[])new Object[]{queueState});
        AbstractQueued abstractQueued = this;
        queueState.queueState = queueState2 = queueState;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"setQueueState", (Object[])new Object[]{queueState}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        boolean bl;
        void o;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"equals", (Object[])new Object[]{object});
        AbstractQueued abstractQueued = this;
        Object object2 = object;
        if (object2 == o) {
            bl = true;
        } else if (!(object2 instanceof AbstractQueued)) {
            bl = false;
        } else {
            AbstractQueued abstractQueued2 = (AbstractQueued)object2;
            if (!abstractQueued2.canEqual(o)) {
                bl = false;
            } else {
                void other$jobExecutorClass;
                void this$jobExecutorClass;
                Class clazz = o.getJobExecutorClass();
                Class clazz2 = this$jobExecutorClass.getJobExecutorClass();
                if (other$jobExecutorClass == null ? clazz2 != null : !other$jobExecutorClass.equals(clazz2)) {
                    bl = false;
                } else {
                    void other$originatingWorker;
                    Worker worker = o.getOriginatingWorker();
                    Worker worker2 = this$jobExecutorClass.getOriginatingWorker();
                    if (other$originatingWorker == null ? worker2 != null : !other$originatingWorker.equals((Object)worker2)) {
                        bl = false;
                    } else {
                        void other$currentJobExecution;
                        JobExecution jobExecution = o.getCurrentJobExecution();
                        JobExecution jobExecution2 = this$jobExecutorClass.getCurrentJobExecution();
                        if (other$currentJobExecution == null ? jobExecution2 != null : !other$currentJobExecution.equals(jobExecution2)) {
                            bl = false;
                        } else {
                            void other$queueState;
                            QueueState queueState = o.getQueueState();
                            QueueState queueState2 = this$jobExecutorClass.getQueueState();
                            bl = !(other$queueState == null ? queueState2 != null : !other$queueState.equals((Object)queueState2));
                        }
                    }
                }
            }
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"equals", (Object[])new Object[]{object}, (Object)bl2, (long)l);
        return bl2;
    }

    protected boolean canEqual(Object object) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"canEqual", (Object[])new Object[]{object});
        AbstractQueued abstractQueued = this;
        Object object2 = object;
        boolean bl = object2 instanceof AbstractQueued;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"canEqual", (Object[])new Object[]{object}, (Object)bl, (long)l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $jobExecutorClass;
        void PRIME;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"hashCode", (Object[])new Object[0]);
        AbstractQueued abstractQueued = this;
        int n = 59;
        boolean bl = true;
        Class clazz = PRIME.getJobExecutorClass();
        $jobExecutorClass = $jobExecutorClass * 59 + (clazz == null ? 43 : clazz.hashCode());
        Worker worker = PRIME.getOriginatingWorker();
        $jobExecutorClass = $jobExecutorClass * 59 + (worker == null ? 43 : ((Object)((Object)worker)).hashCode());
        JobExecution jobExecution = PRIME.getCurrentJobExecution();
        $jobExecutorClass = $jobExecutorClass * 59 + (jobExecution == null ? 43 : ((Object)jobExecution).hashCode());
        QueueState queueState = PRIME.getQueueState();
        void var3_3 = $jobExecutorClass = $jobExecutorClass * 59 + (queueState == null ? 43 : ((Object)((Object)queueState)).hashCode());
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"hashCode", (Object[])new Object[0], (Object)((int)var3_3), (long)l);
        return (int)var3_3;
    }

    public String toString() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"toString", (Object[])new Object[0]);
        Object object = this;
        object = "AbstractQueued(system=" + ((AbstractQueued)object).system + ", jobExecutorClass=" + ((AbstractQueued)object).jobExecutorClass + ", originatingWorker=" + ((AbstractQueued)object).originatingWorker + ", queueDateTime=" + ((AbstractQueued)object).queueDateTime + ", currentJobExecution=" + ((AbstractQueued)object).currentJobExecution + ", queue=" + ((AbstractQueued)object).queue + ", queueState=" + ((AbstractQueued)object).queueState + ")";
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.AbstractQueued", (String)"toString", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }
}

