// Generated by delombok at Mon Dec 16 16:49:23 EST 2019
package io.github.qsy7.queue.impl.worker;

import io.github.qsy7.queue.api.annotation.Job;
import io.github.qsy7.queue.api.annotation.JobExecutionConfiguration;
import io.github.qsy7.queue.api.annotation.scheduling.FixedDelay;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.service.JobWorkerService;
import io.github.qsy7.queue.api.service.QueueService;
// TODO: 1. configure how frequently we poll the backend for jobs
@Job(jobExecutionConfiguration = @JobExecutionConfiguration(system = true), fixedDelay = @FixedDelay(fixedDelay = 60))
public class WorkerSchedulerRunnable extends AbstractRunnable {
  protected final QueueService queueService;
  protected final JobWorkerService jobWorkerService;

  protected void doCall() {
    markJobExecutionAsAborted();
    rescheduleJobs();
  }

  /**
   * For any job that appears to have died, mark it as aborted.
   */
  protected void markJobExecutionAsAborted() {
    queueService.findAbortedJobExecutions().forEach(queuedJob -> {
      markJobExecutionAsAborted(queuedJob);
    });
  }

  protected void markJobExecutionAsAborted(AbstractQueued queued) {
    queued.getJobExecutions().get(queued.getJobExecutions().size() - 1).setExecutionState(ExecutionState.Aborted);
    queueService.update(queued);
  }

  /**
   * For any jobs we may pick up, attempt to assign them out to our local worker.
   */
  protected void rescheduleJobs() {
    queueService.findAssignable().forEach(queuedJob -> jobWorkerService.queue(queuedJob));
    queueService.findRecurringAssignable().forEach(queuedJob -> jobWorkerService.queue(queuedJob));
  }

  @java.lang.SuppressWarnings("all")
  public QueueService getQueueService() {
    return this.queueService;
  }

  @java.lang.SuppressWarnings("all")
  public JobWorkerService getJobWorkerService() {
    return this.jobWorkerService;
  }

  @java.lang.SuppressWarnings("all")
  public WorkerSchedulerRunnable(final QueueService queueService, final JobWorkerService jobWorkerService) {
    this.queueService = queueService;
    this.jobWorkerService = jobWorkerService;
  }
}
