/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.scheduling;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.infrastructure.inject.core.service.StartupAware;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.annotation.Job;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.QueuedJob;
import io.github.qsy7.queue.api.model.ScheduleInstance;
import io.github.qsy7.queue.api.service.QueueService;
import io.github.qsy7.queue.impl.worker.enumeration.ScheduleType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JobQueuer
implements StartupAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobQueuer.class);
    protected final QueueService queueService;
    protected final Reflections reflections;

    /*
     * WARNING - void declaration
     */
    @Inject
    public JobQueuer(QueueService queueService, Reflections reflections) {
        void reflections2;
        void queueService2;
        Object object = this;
        QueueService queueService3 = queueService;
        Reflections reflections3 = reflections;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"<init>", (Object[])new Object[]{queueService3, reflections3});
        JobQueuer jobQueuer = object;
        QueueService queueService4 = queueService3;
        Reflections reflections4 = reflections3;
        queueService2.queueService = reflections2;
        queueService2.reflections = reflections4;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"<init>", (Object[])new Object[]{queueService3, reflections3}, null, (long)l);
        object = (AutoCloseable)((Object)this);
        CloseableUtil.addAutoCloseable((AutoCloseable)object);
    }

    public void startup() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"startup", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        jobQueuer.cancelOldJobs();
        jobQueuer.scheduleJobs();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"startup", (Object[])new Object[0], null, (long)l);
    }

    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"close", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    protected void cancelOldJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelOldJobs", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        jobQueuer.queueService.findAbortedJobExecutions().stream().forEach(queuedJob -> this.cancelJob((AbstractQueued)queuedJob));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelOldJobs", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean cancelJob(AbstractQueued abstractQueued) {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelJob", (Object[])new Object[]{abstractQueued});
        JobQueuer jobQueuer = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        if (QueuedJob.class.isAssignableFrom(abstractQueued2.getClass())) {
            void queuedJob;
            queuedJob.queueService.cancel(abstractQueued2);
            bl = true;
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelJob", (Object[])new Object[]{abstractQueued}, (Object)bl2, (long)l);
        return bl2;
    }

    protected void scheduleJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJobs", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        jobQueuer.getQueuedJobs().stream().forEach(queuedJob -> this.scheduleJob((QueuedJob)queuedJob));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJobs", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void scheduleJob(QueuedJob queuedJob) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJob", (Object[])new Object[]{queuedJob});
        JobQueuer jobQueuer = this;
        QueuedJob queuedJob2 = queuedJob;
        try {
            void queuedJob3;
            queuedJob3.queueService.queue((AbstractQueued)queuedJob2);
        }
        catch (Exception exception) {
            LOGGER.warn("Error running queuedJob", (Throwable)exception);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJob", (Object[])new Object[]{queuedJob}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Set<QueuedJob> getQueuedJobs() {
        void queuedJobs;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"getQueuedJobs", (Object[])new Object[0]);
        Object object = this;
        HashSet<QueuedJob> hashSet = new HashSet<QueuedJob>();
        for (Class clazz : queuedJobs.reflections.getTypesAnnotatedWith(Job.class)) {
            void job;
            Job job2 = clazz.getAnnotation(Job.class);
            queuedJobs.addJobs(hashSet, queuedJobs.getScheduleInstances(job2), (Class)job, job2.jobExecutionConfiguration().system());
        }
        object = hashSet;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"getQueuedJobs", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected Set<ScheduleInstance> getScheduleInstances(Job job) {
        void scheduleInstances;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"getScheduleInstances", (Object[])new Object[]{job});
        Object object = this;
        Job job2 = job;
        HashSet hashSet = new HashSet();
        Arrays.stream(ScheduleType.values()).forEach(arg_0 -> JobQueuer.lambda$getScheduleInstances$2(hashSet, (Job)scheduleInstances, arg_0));
        object = hashSet;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"getScheduleInstances", (Object[])new Object[]{job}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void addJobs(Set<QueuedJob> set, Set<ScheduleInstance> set2, Class clazz, boolean bl) {
        void system;
        void scheduleInstances;
        void queuedJobs;
        void jobClass;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"addJobs", (Object[])new Object[]{set, set2, clazz, bl});
        JobQueuer jobQueuer = this;
        Set<QueuedJob> set3 = set;
        Set<ScheduleInstance> set4 = set2;
        Class clazz2 = clazz;
        boolean bl2 = bl;
        jobClass.stream().forEach(arg_0 -> ((JobQueuer)queuedJobs).lambda$addJobs$3((Set)scheduleInstances, (Class)system, bl2, arg_0));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"addJobs", (Object[])new Object[]{set, set2, clazz, bl}, null, (long)l);
    }

    private /* synthetic */ void lambda$addJobs$3(Set queuedJobs, Class jobClass, boolean system, ScheduleInstance scheduleInstance) {
        queuedJobs.add((QueuedJob)this.queueService.queue((AbstractQueued)new QueuedJob(jobClass, scheduleInstance, system)));
    }

    private static /* synthetic */ void lambda$getScheduleInstances$2(Set scheduleInstances, Job jobAnnotation, ScheduleType scheduleType) {
        scheduleType.getScheduleInstanceBuilder().getDelay(scheduleInstances, jobAnnotation);
    }
}

