/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.scheduling;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.enumeration.ActionType;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import io.github.qsy7.queue.api.enumeration.QueueState;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.JobExecution;
import io.github.qsy7.queue.api.model.Worker;
import io.github.qsy7.queue.api.service.JobWorkerService;
import io.github.qsy7.queue.api.service.QueueService;
import io.github.qsy7.queue.impl.scheduling.JobCancellationException;
import javax.transaction.Transactional;

public abstract class AbstractQueueService
implements QueueService {
    protected final JobWorkerService jobWorkerService;
    protected final Worker worker;

    /*
     * WARNING - void declaration
     */
    @Transactional
    public <QueuedType extends AbstractQueued> QueuedType cancel(QueuedType QueuedType) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.AbstractQueueService", (String)"cancel", (Object[])new Object[]{QueuedType});
        AbstractQueueService abstractQueueService = this;
        QueuedType QueuedType2 = QueuedType;
        AbstractQueueService abstractQueueService2 = abstractQueueService;
        QueuedType QueuedType3 = QueuedType2;
        try {
            void queued;
            queued = abstractQueueService2.refresh(queued);
            if (!queued.getQueueState().isCancellable()) {
                throw new JobCancellationException((Enum)queued.getQueueState());
            }
            queued.setQueueState(QueueState.Cancelled);
            abstractQueueService2.jobWorkerService.cancel((AbstractQueued)queued);
            abstractQueueService2 = abstractQueueService2.update((AbstractQueued)queued);
            return (QueuedType)abstractQueueService2;
        }
        finally {
            QueuedType3 = null;
        }
    }

    public JobExecution cancel(JobExecution jobExecution) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.AbstractQueueService", (String)"cancel", (Object[])new Object[]{jobExecution});
        AbstractQueueService abstractQueueService = this;
        JobExecution jobExecution2 = jobExecution;
        AbstractQueueService abstractQueueService2 = abstractQueueService;
        JobExecution jobExecution3 = jobExecution2;
        try {
            JobExecution jobExecution4;
            jobExecution4 = abstractQueueService2.refresh(jobExecution4);
            if (!ActionType.Cancel.isSupported(jobExecution4.getExecutionState())) {
                throw new JobCancellationException((Enum)jobExecution4.getExecutionState());
            }
            jobExecution4.setExecutionState(ExecutionState.Cancelled);
            abstractQueueService2.jobWorkerService.cancel(jobExecution4);
            abstractQueueService2 = abstractQueueService2.update(jobExecution4);
            return abstractQueueService2;
        }
        finally {
            jobExecution3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <QueuedType extends AbstractQueued> QueuedType queue(QueuedType QueuedType) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.AbstractQueueService", (String)"queue", (Object[])new Object[]{QueuedType});
        AbstractQueueService abstractQueueService = this;
        QueuedType QueuedType2 = QueuedType;
        AbstractQueueService abstractQueueService2 = abstractQueueService;
        QueuedType QueuedType3 = QueuedType2;
        try {
            void queued;
            if (queued.getId() > 0) {
                queued.setOriginatingWorker(abstractQueueService2.worker);
                abstractQueueService2.create(queued);
            }
            abstractQueueService2.jobWorkerService.queue((AbstractQueued)queued);
            abstractQueueService2 = queued;
            return (QueuedType)abstractQueueService2;
        }
        finally {
            QueuedType3 = null;
        }
    }

    protected abstract <QueuedType extends AbstractQueued> QueuedType refresh(QueuedType var1);

    protected abstract JobExecution refresh(JobExecution var1);

    protected abstract <QueuedType extends AbstractQueued> QueuedType create(QueuedType var1);

    protected abstract JobExecution update(JobExecution var1);

    /*
     * WARNING - void declaration
     */
    public AbstractQueueService(JobWorkerService jobWorkerService, Worker worker) {
        void worker2;
        void jobWorkerService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.scheduling.AbstractQueueService", (String)"<init>", (Object[])new Object[]{jobWorkerService, worker});
        AbstractQueueService abstractQueueService = this;
        JobWorkerService jobWorkerService3 = jobWorkerService;
        Worker worker3 = worker;
        abstractQueueService.jobWorkerService = jobWorkerService2;
        abstractQueueService.worker = worker2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.scheduling.AbstractQueueService", (String)"<init>", (Object[])new Object[]{jobWorkerService, worker}, null, (long)l);
    }
}

