package io.github.qsy7.remote.impl.plugins.ssh;

import io.github.qsy7.queue.api.annotation.JobExecutionConfiguration;
import io.github.qsy7.queue.api.enumeration.Durability;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.event.annotation.SubscribeTo;
import io.github.qsy7.ssh.api.SSHCommandService;
import io.github.qsy7.timeout.TimeConstrainedMethodInvocation;
import io.github.qsy7.timeout.annotation.TimeConstrained;
import java.time.Duration;
import javax.inject.Inject;

// the timeout for this queuedJob to complete is highly dependent on the command being asked to run
@SubscribeTo(
    eventClass = SSHCommandMessage.class,
    jobExecutionConfiguration = @JobExecutionConfiguration(durability = Durability.Persistent))
public class SSHCommandMessageJobRunnable extends AbstractRunnable
    implements TimeConstrainedMethodInvocation {
  protected final SSHCommandService sshCommandService;

  @Inject
  public SSHCommandMessageJobRunnable(SSHCommandService sshCommandService) {
    this.sshCommandService = sshCommandService;
  }

  @TimeConstrained
  @Override
  protected void doCall() {
    //    sshCommandService.execute(entity.getCommand());
  }

  @Override
  public Duration getAllowedExecutionDuration() {
    //    return Duration.of(entity.getCommand().getShellCommand().getTimeout(),
    // ChronoUnit.SECONDS);
    return null;
  }
}
