/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.aspects.AfterThrowingAspect;
import io.github.qsy7.logging.aspects.DebugMethodLoggerAspect;
import io.github.qsy7.logging.aspects.TraceMethodLoggerAspect;
import io.github.qsy7.property.impl.annotation.Property;
import io.github.qsy7.shell.api.enumeration.PingResponseType;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.model.ping.PingRequest;
import io.github.qsy7.shell.api.model.ping.PingResponse;
import io.github.qsy7.shell.api.service.PingService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.property.PingTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.DefaultPingService$AjcClosure1;
import io.github.qsy7.shell.impl.service.DefaultPingService$AjcClosure11;
import io.github.qsy7.shell.impl.service.DefaultPingService$AjcClosure3;
import io.github.qsy7.shell.impl.service.DefaultPingService$AjcClosure5;
import io.github.qsy7.shell.impl.service.DefaultPingService$AjcClosure7;
import io.github.qsy7.shell.impl.service.DefaultPingService$AjcClosure9;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DefaultPingService
extends AbstractSingleShellCommandService<PingRequest>
implements PingService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Inject
    public DefaultPingService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=PingTimeout.class) int pingTimeout) {
        super(shellCommandBuilder, shellExecutionService, pingTimeout);
    }

    @Override
    protected String getCommandLine(PingRequest pingRequest) {
        PingRequest pingRequest2 = pingRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)pingRequest2);
        try {
            Object[] objectArray = new Object[]{this, pingRequest2, joinPoint};
            DefaultPingService$AjcClosure1 defaultPingService$AjcClosure1 = new DefaultPingService$AjcClosure1(objectArray);
            return (String)DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultPingService$AjcClosure1.linkClosureAndJoinPoint(69648));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    protected void doAfter(PingRequest pingRequest) {
        PingRequest pingRequest2 = pingRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)pingRequest2);
        try {
            Object[] objectArray = new Object[]{this, pingRequest2, joinPoint};
            DefaultPingService$AjcClosure3 defaultPingService$AjcClosure3 = new DefaultPingService$AjcClosure3(objectArray);
            DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultPingService$AjcClosure3.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void handleOther(PingRequest pingRequest) {
        PingRequest pingRequest2 = pingRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)pingRequest2);
        try {
            Object[] objectArray = new Object[]{this, pingRequest2, joinPoint};
            DefaultPingService$AjcClosure5 defaultPingService$AjcClosure5 = new DefaultPingService$AjcClosure5(objectArray);
            DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultPingService$AjcClosure5.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected IPAddress getIPAddress(ShellCommand shellCommand) {
        ShellCommand shellCommand2 = shellCommand;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)shellCommand2);
        try {
            Object[] objectArray = new Object[]{this, shellCommand2, joinPoint};
            DefaultPingService$AjcClosure7 defaultPingService$AjcClosure7 = new DefaultPingService$AjcClosure7(objectArray);
            return (IPAddress)DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultPingService$AjcClosure7.linkClosureAndJoinPoint(69648));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static String getIPAddressFromPingOutput(ShellCommand shellCommand) {
        ShellCommand shellCommand2 = shellCommand;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)shellCommand2);
        try {
            Object[] objectArray = new Object[]{shellCommand2, joinPoint};
            DefaultPingService$AjcClosure9 defaultPingService$AjcClosure9 = new DefaultPingService$AjcClosure9(objectArray);
            return (String)TraceMethodLoggerAspect.aspectOf().doPrivateAround(defaultPingService$AjcClosure9.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static final List<PingResponse> getPingStatistics(PingRequest pingRequest, ShellCommand shellCommand) {
        PingRequest pingRequest2 = pingRequest;
        ShellCommand shellCommand2 = shellCommand;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)pingRequest2, (Object)shellCommand2);
        try {
            Object[] objectArray = new Object[]{pingRequest2, shellCommand2, joinPoint};
            DefaultPingService$AjcClosure11 defaultPingService$AjcClosure11 = new DefaultPingService$AjcClosure11(objectArray);
            return (List)TraceMethodLoggerAspect.aspectOf().doPrivateAround(defaultPingService$AjcClosure11.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        DefaultPingService.ajc$preClinit();
    }

    static final /* synthetic */ String getCommandLine_aroundBody0(DefaultPingService ajc$this, PingRequest pingRequest, JoinPoint joinPoint) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("ping");
        if (pingRequest.getCount() > 0) {
            arguments.add("-c");
            arguments.add(Integer.toString(pingRequest.getCount()));
        } else {
            arguments.add("-c");
            arguments.add("1");
        }
        if (pingRequest.getInterval() > 0) {
            arguments.add("-i");
            arguments.add(Integer.toString(pingRequest.getInterval()));
        }
        if (pingRequest.getTimeout() > 0) {
            arguments.add("-W");
            arguments.add(Integer.toString(pingRequest.getTimeout()));
        }
        arguments.add(pingRequest.getNetworkDiagnosticTest().getFqdn());
        return String.join((CharSequence)" ", arguments);
    }

    static final /* synthetic */ void doAfter_aroundBody2(DefaultPingService ajc$this, PingRequest pingRequest, JoinPoint joinPoint) {
        if (pingRequest.getShellCommand().getReturnCode() == 0) {
            for (CommandOutput commandOutput : pingRequest.getShellCommand().getOutputs()) {
                if (!commandOutput.getOutput().contains("ping statistics")) continue;
                IPAddress ipAddress = ajc$this.getIPAddress(pingRequest.getShellCommand());
                pingRequest.setIpAddress(ipAddress);
                pingRequest.setPingResponseType(PingResponseType.Good);
                pingRequest.getPingResponses().addAll(DefaultPingService.getPingStatistics(pingRequest, pingRequest.getShellCommand()));
                return;
            }
            throw new RuntimeException("Unexpected output, did NOT find ping statistics header");
        }
        if (pingRequest.getShellCommand().getReturnCode() == 2) {
            pingRequest.setPingResponseType(PingResponseType.UnknownHost);
            return;
        }
        if (pingRequest.getShellCommand().getReturnCode() == 1) {
            pingRequest.setPingResponseType(PingResponseType.NoResponse);
            return;
        }
        ajc$this.handleOther(pingRequest);
    }

    static final /* synthetic */ void handleOther_aroundBody4(DefaultPingService ajc$this, PingRequest pingRequest, JoinPoint joinPoint) {
        pingRequest.setPingResponseType(PingResponseType.Other);
    }

    static final /* synthetic */ IPAddress getIPAddress_aroundBody6(DefaultPingService ajc$this, ShellCommand shellCommand, JoinPoint joinPoint) {
        return new IPAddress(DefaultPingService.getIPAddressFromPingOutput(shellCommand));
    }

    static final /* synthetic */ String getIPAddressFromPingOutput_aroundBody8(ShellCommand shellCommand, JoinPoint joinPoint) {
        return ((CommandOutput)shellCommand.getOutputs().get(0)).getOutput().split(" ")[2].replace("(", "").replace(")", "");
    }

    static final /* synthetic */ List getPingStatistics_aroundBody10(PingRequest pingRequest, ShellCommand shellCommand, JoinPoint joinPoint) {
        ArrayList<PingResponse> pingResponses = new ArrayList<PingResponse>();
        for (int i = 1; i < shellCommand.getOutputs().size() && !((CommandOutput)shellCommand.getOutputs().get(i)).getOutput().contains("ping statistics") && ((CommandOutput)shellCommand.getOutputs().get(i)).getOutput() != null && !((CommandOutput)shellCommand.getOutputs().get(i)).getOutput().trim().isEmpty(); ++i) {
            String[] splitLine = ((CommandOutput)shellCommand.getOutputs().get(i)).getOutput().split(" ");
            int ttl = Integer.valueOf(splitLine[6].replace("ttl=", ""));
            double time = Double.valueOf(splitLine[7].replace("time=", ""));
            pingResponses.add(new PingResponse(pingRequest, i - 1, ttl, time));
        }
        return pingResponses;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultPingService.java", DefaultPingService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getCommandLine", "io.github.qsy7.shell.impl.service.DefaultPingService", "io.github.qsy7.shell.api.model.ping.PingRequest", "pingRequest", "", "java.lang.String"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doAfter", "io.github.qsy7.shell.impl.service.DefaultPingService", "io.github.qsy7.shell.api.model.ping.PingRequest", "pingRequest", "", "void"), 54);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleOther", "io.github.qsy7.shell.impl.service.DefaultPingService", "io.github.qsy7.shell.api.model.ping.PingRequest", "pingRequest", "", "void"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getIPAddress", "io.github.qsy7.shell.impl.service.DefaultPingService", "io.github.qsy7.shell.api.model.ShellCommand", "shellCommand", "", "io.github.qsy7.shell.api.model.IPAddress"), 93);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getIPAddressFromPingOutput", "io.github.qsy7.shell.impl.service.DefaultPingService", "io.github.qsy7.shell.api.model.ShellCommand", "shellCommand", "", "java.lang.String"), 97);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a", "getPingStatistics", "io.github.qsy7.shell.impl.service.DefaultPingService", "io.github.qsy7.shell.api.model.ping.PingRequest:io.github.qsy7.shell.api.model.ShellCommand", "pingRequest:shellCommand", "", "java.util.List"), 108);
    }
}

