/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.aspects.AfterThrowingAspect;
import io.github.qsy7.logging.aspects.DebugMethodLoggerAspect;
import io.github.qsy7.property.impl.annotation.Property;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.traceroute.TracerouteHop;
import io.github.qsy7.shell.api.model.traceroute.TracerouteRequest;
import io.github.qsy7.shell.api.model.traceroute.TracrouteHopResponse;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.api.service.TracerouteService;
import io.github.qsy7.shell.impl.property.TracerouteTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.DefaultTracerouteService$AjcClosure1;
import io.github.qsy7.shell.impl.service.DefaultTracerouteService$AjcClosure3;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DefaultTracerouteService
extends AbstractSingleShellCommandService<TracerouteRequest>
implements TracerouteService {
    private static final Pattern TRACEROUTE_OUTPUT_PATTERN;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Inject
    public DefaultTracerouteService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=TracerouteTimeout.class) int timeout) {
        super(shellCommandBuilder, shellExecutionService, timeout);
    }

    @Override
    protected String getCommandLine(TracerouteRequest tracerouteRequest) {
        TracerouteRequest tracerouteRequest2 = tracerouteRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tracerouteRequest2);
        try {
            Object[] objectArray = new Object[]{this, tracerouteRequest2, joinPoint};
            DefaultTracerouteService$AjcClosure1 defaultTracerouteService$AjcClosure1 = new DefaultTracerouteService$AjcClosure1(objectArray);
            return (String)DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultTracerouteService$AjcClosure1.linkClosureAndJoinPoint(69648));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    protected void doAfter(TracerouteRequest tracerouteRequest) {
        TracerouteRequest tracerouteRequest2 = tracerouteRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)tracerouteRequest2);
        try {
            Object[] objectArray = new Object[]{this, tracerouteRequest2, joinPoint};
            DefaultTracerouteService$AjcClosure3 defaultTracerouteService$AjcClosure3 = new DefaultTracerouteService$AjcClosure3(objectArray);
            DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultTracerouteService$AjcClosure3.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        DefaultTracerouteService.ajc$preClinit();
        TRACEROUTE_OUTPUT_PATTERN = Pattern.compile("^([\\d]{1,})  ([\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3})  (.*)$");
    }

    static final /* synthetic */ String getCommandLine_aroundBody0(DefaultTracerouteService ajc$this, TracerouteRequest tracerouteRequest, JoinPoint joinPoint) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("sudo");
        arguments.add("traceroute");
        arguments.add("-I");
        if (tracerouteRequest.isIpv4()) {
            arguments.add("-4");
        } else {
            arguments.add("-6");
        }
        if (tracerouteRequest.getMaxHops() > 0) {
            arguments.add("-m");
            arguments.add(Integer.toString(tracerouteRequest.getMaxHops()));
        }
        if (tracerouteRequest.isNoFragment()) {
            arguments.add("-F");
        }
        if (tracerouteRequest.getQueriesPerHop() > 0) {
            arguments.add("-q");
            arguments.add(Integer.toString(tracerouteRequest.getQueriesPerHop()));
        }
        arguments.add("-n");
        arguments.add(tracerouteRequest.getNetworkDiagnosticTest().getFqdn());
        return String.join((CharSequence)" ", arguments.toArray(new String[arguments.size()]));
    }

    static final /* synthetic */ void doAfter_aroundBody2(DefaultTracerouteService ajc$this, TracerouteRequest tracerouteRequest, JoinPoint joinPoint) {
        int index = 0;
        for (CommandOutput commandOutput : tracerouteRequest.getShellCommand().getOutputs()) {
            if (index <= 0) continue;
            String line = commandOutput.getOutput().trim().replace("ms", "");
            Matcher matcher = TRACEROUTE_OUTPUT_PATTERN.matcher(line);
            if (matcher.matches()) {
                TracerouteHop tracerouteHop = new TracerouteHop(tracerouteRequest, index, null, new IPAddress(matcher.group(2)));
                tracerouteRequest.getTracerouteHops().add(tracerouteHop);
                int j = 0;
                for (String hopTime : matcher.group(3).split("  ")) {
                    try {
                        tracerouteHop.getTracrouteHopResponses().add(new TracrouteHopResponse(j, Double.valueOf(hopTime).doubleValue(), tracerouteHop));
                    }
                    catch (NumberFormatException e) {
                        tracerouteHop.getTracrouteHopResponses().add(new TracrouteHopResponse(j, -1.0, tracerouteHop));
                    }
                    ++j;
                }
            }
            ++index;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultTracerouteService.java", DefaultTracerouteService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getCommandLine", "io.github.qsy7.shell.impl.service.DefaultTracerouteService", "io.github.qsy7.shell.api.model.traceroute.TracerouteRequest", "tracerouteRequest", "", "java.lang.String"), 32);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doAfter", "io.github.qsy7.shell.impl.service.DefaultTracerouteService", "io.github.qsy7.shell.api.model.traceroute.TracerouteRequest", "tracerouteRequest", "", "void"), 62);
    }
}

