package io.github.qsy7.shell.impl.collector;

import io.github.qsy7.shell.api.service.OutputCollector;
import java.io.IOException;

public class AppendableOutputCollector implements OutputCollector {
  protected final Appendable appendable;

  public AppendableOutputCollector(Appendable appendable) {

    this.appendable = appendable;
  }

  @Override
  public void onData(String line, boolean isError) {
    try {
      appendable.append(line);
    } catch (IOException e) {
      throw new RuntimeException("Error appending line:", e);
    }
  }
}
