/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.enumeration.PingResponseType;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.model.ping.PingRequest;
import io.github.qsy7.shell.api.model.ping.PingResponse;
import io.github.qsy7.shell.api.service.PingService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.property.PingTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class DefaultPingService
extends AbstractSingleShellCommandService<PingRequest>
implements PingService {
    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultPingService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=PingTimeout.class) int n) {
        void pingTimeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n});
        DefaultPingService defaultPingService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        int n2 = n;
        super((ShellCommandBuilder)shellExecutionService2, (ShellExecutionService)pingTimeout, n2);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCommandLine(PingRequest pingRequest) {
        void arguments;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getCommandLine", (Object[])new Object[]{pingRequest});
        Object object = this;
        PingRequest pingRequest2 = pingRequest;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ping");
        if (arguments.getCount() > 0) {
            arrayList.add("-c");
            arrayList.add(Integer.toString(arguments.getCount()));
        } else {
            arrayList.add("-c");
            arrayList.add("1");
        }
        if (arguments.getInterval() > 0) {
            arrayList.add("-i");
            arrayList.add(Integer.toString(arguments.getInterval()));
        }
        if (arguments.getTimeout() > 0) {
            arrayList.add("-W");
            arrayList.add(Integer.toString(arguments.getTimeout()));
        }
        arrayList.add(arguments.getNetworkDiagnosticTest().getFqdn());
        object = String.join((CharSequence)" ", arrayList);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getCommandLine", (Object[])new Object[]{pingRequest}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAfter(PingRequest pingRequest) {
        long l;
        block6: {
            void pingRequest2;
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"doAfter", (Object[])new Object[]{pingRequest});
            DefaultPingService defaultPingService = this;
            PingRequest pingRequest3 = pingRequest;
            if (pingRequest3.getShellCommand().getReturnCode() == 0) {
                for (CommandOutput commandOutput : pingRequest3.getShellCommand().getOutputs()) {
                    if (!commandOutput.getOutput().contains("ping statistics")) continue;
                    IPAddress iPAddress = pingRequest2.getIPAddress(pingRequest3.getShellCommand());
                    pingRequest3.setIpAddress(iPAddress);
                    pingRequest3.setPingResponseType(PingResponseType.Good);
                    pingRequest3.getPingResponses().addAll(DefaultPingService.getPingStatistics(pingRequest3, pingRequest3.getShellCommand()));
                    break block6;
                }
                throw new RuntimeException("Unexpected output, did NOT find ping statistics header");
            }
            if (pingRequest3.getShellCommand().getReturnCode() == 2) {
                pingRequest3.setPingResponseType(PingResponseType.UnknownHost);
            } else if (pingRequest3.getShellCommand().getReturnCode() == 1) {
                pingRequest3.setPingResponseType(PingResponseType.NoResponse);
            } else {
                pingRequest2.handleOther(pingRequest3);
            }
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"doAfter", (Object[])new Object[]{pingRequest}, null, (long)l);
    }

    protected void handleOther(PingRequest pingRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"handleOther", (Object[])new Object[]{pingRequest});
        DefaultPingService defaultPingService = this;
        PingRequest pingRequest2 = pingRequest;
        pingRequest2.setPingResponseType(PingResponseType.Other);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"handleOther", (Object[])new Object[]{pingRequest}, null, (long)l);
    }

    protected IPAddress getIPAddress(ShellCommand shellCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getIPAddress", (Object[])new Object[]{shellCommand});
        DefaultPingService defaultPingService = this;
        ShellCommand shellCommand2 = shellCommand;
        defaultPingService = new IPAddress(DefaultPingService.getIPAddressFromPingOutput(shellCommand2));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getIPAddress", (Object[])new Object[]{shellCommand}, (Object)defaultPingService, (long)l);
        return defaultPingService;
    }

    private static String getIPAddressFromPingOutput(ShellCommand shellCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getIPAddressFromPingOutput", (Object[])new Object[]{shellCommand});
        Object object = shellCommand;
        object = ((CommandOutput)object.getOutputs().get(0)).getOutput().split(" ")[2].replace("(", "").replace(")", "");
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getIPAddressFromPingOutput", (Object[])new Object[]{shellCommand}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PingResponse> getPingStatistics(PingRequest pingRequest, ShellCommand shellCommand) {
        void pingResponses;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getPingStatistics", (Object[])new Object[]{pingRequest, shellCommand});
        Object object = pingRequest;
        ShellCommand shellCommand2 = shellCommand;
        ArrayList arrayList = new ArrayList();
        for (int i = 1; i < pingResponses.getOutputs().size() && !((CommandOutput)pingResponses.getOutputs().get(i)).getOutput().contains("ping statistics") && ((CommandOutput)pingResponses.getOutputs().get(i)).getOutput() != null && !((CommandOutput)pingResponses.getOutputs().get(i)).getOutput().trim().isEmpty(); ++i) {
            void time;
            void splitLine;
            void shellCommand3;
            void i2;
            void ttl;
            String[] stringArray = ((CommandOutput)pingResponses.getOutputs().get(i)).getOutput().split(" ");
            int n = Integer.valueOf(stringArray[6].replace("ttl=", ""));
            double d = Double.valueOf(ttl[7].replace("time=", ""));
            i2.add(new PingResponse((PingRequest)shellCommand3, (int)(splitLine - true), (int)time, d));
        }
        object = arrayList;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultPingService", (String)"getPingStatistics", (Object[])new Object[]{pingRequest, shellCommand}, (Object)object, (long)l);
        return object;
    }
}

