/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.Chrootable;
import io.github.qsy7.shell.api.model.EnvironmentAware;
import io.github.qsy7.shell.api.model.FreeBSDJailShellCommand;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.model.ShellCommandEnvironmentProperty;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.ShellProcessExecution;
import io.github.qsy7.shell.impl.annotation.EntityEnabled;
import io.github.qsy7.shell.impl.property.InterruptGracePeriodUnits;
import io.github.qsy7.shell.impl.property.InterruptGracePeriodValue;
import io.github.qsy7.shell.impl.util.ShellExecutionUtil;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;

public class DefaultShellExecution
implements ShellExecutionService,
AutoCloseable {
    protected boolean shutdown;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;

    @Inject
    public DefaultShellExecution(@Property(value=InterruptGracePeriodUnits.class) ChronoUnit chronoUnit, @Property(value=InterruptGracePeriodValue.class) long l) {
        AutoCloseable autoCloseable = this;
        ChronoUnit chronoUnit2 = chronoUnit;
        long l2 = l;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"<init>", (Object[])new Object[]{chronoUnit2, l2});
        DefaultShellExecution defaultShellExecution = autoCloseable;
        ChronoUnit chronoUnit3 = chronoUnit2;
        long l4 = l2;
        defaultShellExecution.interruptGracePeriodUnits = chronoUnit3;
        defaultShellExecution.interruptGracePeriodValue = l4;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"<init>", (Object[])new Object[]{chronoUnit2, l2}, null, (long)l3);
        autoCloseable = this;
        CloseableUtil.addAutoCloseable((AutoCloseable)autoCloseable);
    }

    /*
     * WARNING - void declaration
     */
    @EntityEnabled
    public ShellCommand run(ShellCommand shellCommand) throws Exception {
        void shellCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"run", (Object[])new Object[]{shellCommand});
        DefaultShellExecution defaultShellExecution = this;
        ShellCommand shellCommand3 = shellCommand;
        shellCommand2.checkIfShutdown();
        shellCommand2.doRun(shellCommand3);
        defaultShellExecution = shellCommand3;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"run", (Object[])new Object[]{shellCommand}, (Object)defaultShellExecution, (long)l);
        return defaultShellExecution;
    }

    protected void checkIfShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"checkIfShutdown", (Object[])new Object[0]);
        DefaultShellExecution defaultShellExecution = this;
        if (defaultShellExecution.shutdown) {
            throw new IllegalStateException("Service is shutting down");
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"checkIfShutdown", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doRun(ShellCommand shellCommand) throws IOException, InterruptedException {
        void shellCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doRun", (Object[])new Object[]{shellCommand});
        DefaultShellExecution defaultShellExecution = this;
        ShellCommand shellCommand3 = shellCommand;
        new ShellProcessExecution(shellCommand2.setupProcess(shellCommand3), shellCommand3, shellCommand2.interruptGracePeriodUnits, shellCommand2.interruptGracePeriodValue).run();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doRun", (Object[])new Object[]{shellCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Process setupProcess(ShellCommand shellCommand) throws IOException {
        void shellCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setupProcess", (Object[])new Object[]{shellCommand});
        Object object = this;
        ShellCommand shellCommand3 = shellCommand;
        object = shellCommand3 instanceof Chrootable ? (shellCommand3 instanceof FreeBSDJailShellCommand ? shellCommand2.doFreeBSDJailChrootProcess(shellCommand3) : shellCommand2.doChrootProcess(shellCommand3)) : ShellExecutionUtil.doNonChrootProcess(shellCommand3);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setupProcess", (Object[])new Object[]{shellCommand}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected Process doFreeBSDJailChrootProcess(ShellCommand shellCommand) throws IOException {
        Process process;
        void chrootable;
        void shellCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doFreeBSDJailChrootProcess", (Object[])new Object[]{shellCommand});
        Object object = this;
        ShellCommand shellCommand3 = shellCommand;
        Chrootable chrootable2 = (Chrootable)shellCommand3;
        shellCommand2.doValidate((ShellCommand)chrootable, chrootable2);
        if (chrootable instanceof EnvironmentAware) {
            ProcessBuilder processBuilder = new ProcessBuilder(ShellExecutionUtil.getProcessBuilderChrootCmdLine(chrootable2));
            DefaultShellExecution.setEnvironment(processBuilder, (EnvironmentAware)chrootable.getShellCommandEnvironmentProperties());
            process = processBuilder.start();
        } else {
            process = Runtime.getRuntime().exec(ShellExecutionUtil.getChrootCmdLine(chrootable2));
        }
        object = process;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doFreeBSDJailChrootProcess", (Object[])new Object[]{shellCommand}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void setEnvironment(ProcessBuilder processBuilder, EnvironmentAware environmentAware) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironment", (Object[])new Object[]{processBuilder, environmentAware});
        ProcessBuilder processBuilder2 = processBuilder;
        EnvironmentAware environmentAware2 = environmentAware;
        for (ShellCommandEnvironmentProperty shellCommandEnvironmentProperty : environmentAware2.getShellCommandEnvironmentProperties()) {
            void environmentAware3;
            DefaultShellExecution.setEnvironmentProperty((ProcessBuilder)environmentAware3, shellCommandEnvironmentProperty);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironment", (Object[])new Object[]{processBuilder, environmentAware}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    private static void setEnvironmentProperty(ProcessBuilder processBuilder, ShellCommandEnvironmentProperty shellCommandEnvironmentProperty) {
        void shellCommandEnvironmentProperty2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironmentProperty", (Object[])new Object[]{processBuilder, shellCommandEnvironmentProperty});
        ProcessBuilder processBuilder2 = processBuilder;
        ShellCommandEnvironmentProperty shellCommandEnvironmentProperty3 = shellCommandEnvironmentProperty;
        shellCommandEnvironmentProperty2.environment().put(shellCommandEnvironmentProperty3.getKey(), shellCommandEnvironmentProperty3.getValue());
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironmentProperty", (Object[])new Object[]{processBuilder, shellCommandEnvironmentProperty}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Process doChrootProcess(ShellCommand shellCommand) throws IOException {
        Process process;
        void chrootable;
        void shellCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doChrootProcess", (Object[])new Object[]{shellCommand});
        Object object = this;
        ShellCommand shellCommand3 = shellCommand;
        Chrootable chrootable2 = (Chrootable)shellCommand3;
        shellCommand2.doValidate((ShellCommand)chrootable, chrootable2);
        if (chrootable instanceof EnvironmentAware && chrootable instanceof EnvironmentAware) {
            ProcessBuilder processBuilder = new ProcessBuilder(ShellExecutionUtil.getProcessBuilderChrootCmdLine(chrootable2));
            DefaultShellExecution.setEnvironment(processBuilder, (EnvironmentAware)chrootable);
            process = processBuilder.start();
        } else {
            process = Runtime.getRuntime().exec(ShellExecutionUtil.getChrootCmdLine(chrootable2));
        }
        object = process;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doChrootProcess", (Object[])new Object[]{shellCommand}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void doValidate(ShellCommand shellCommand, Chrootable chrootable) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doValidate", (Object[])new Object[]{shellCommand, chrootable});
        DefaultShellExecution defaultShellExecution = this;
        ShellCommand shellCommand2 = shellCommand;
        Chrootable chrootable2 = chrootable;
        if (chrootable2.getChrootPath() == null || chrootable2.getChrootPath().isEmpty()) {
            void chrootable3;
            throw new IllegalStateException("Cannot chroot, chroot path is null:" + chrootable3.getCommandLine());
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doValidate", (Object[])new Object[]{shellCommand, chrootable}, null, (long)l);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"close", (Object[])new Object[0]);
        DefaultShellExecution defaultShellExecution = this;
        defaultShellExecution.shutdown = true;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"close", (Object[])new Object[0], null, (long)l);
    }
}

