/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.traceroute.TracerouteHop;
import io.github.qsy7.shell.api.model.traceroute.TracerouteRequest;
import io.github.qsy7.shell.api.model.traceroute.TracrouteHopResponse;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.api.service.TracerouteService;
import io.github.qsy7.shell.impl.property.TracerouteTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class DefaultTracerouteService
extends AbstractSingleShellCommandService<TracerouteRequest>
implements TracerouteService {
    private static final Pattern TRACEROUTE_OUTPUT_PATTERN = Pattern.compile("^([\\d]{1,})  ([\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3})  (.*)$");

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultTracerouteService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=TracerouteTimeout.class) int n) {
        void timeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n});
        DefaultTracerouteService defaultTracerouteService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        int n2 = n;
        super((ShellCommandBuilder)shellExecutionService2, (ShellExecutionService)timeout, n2);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCommandLine(TracerouteRequest tracerouteRequest) {
        void arguments;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"getCommandLine", (Object[])new Object[]{tracerouteRequest});
        Object object = this;
        TracerouteRequest tracerouteRequest2 = tracerouteRequest;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sudo");
        arrayList.add("traceroute");
        arrayList.add("-I");
        if (arguments.isIpv4()) {
            arrayList.add("-4");
        } else {
            arrayList.add("-6");
        }
        if (arguments.getMaxHops() > 0) {
            arrayList.add("-m");
            arrayList.add(Integer.toString(arguments.getMaxHops()));
        }
        if (arguments.isNoFragment()) {
            arrayList.add("-F");
        }
        if (arguments.getQueriesPerHop() > 0) {
            arrayList.add("-q");
            arrayList.add(Integer.toString(arguments.getQueriesPerHop()));
        }
        arrayList.add("-n");
        arrayList.add(arguments.getNetworkDiagnosticTest().getFqdn());
        object = String.join((CharSequence)" ", arrayList.toArray(new String[arrayList.size()]));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"getCommandLine", (Object[])new Object[]{tracerouteRequest}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAfter(TracerouteRequest tracerouteRequest) {
        void index;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"doAfter", (Object[])new Object[]{tracerouteRequest});
        DefaultTracerouteService defaultTracerouteService = this;
        TracerouteRequest tracerouteRequest2 = tracerouteRequest;
        int n = 0;
        for (CommandOutput commandOutput : index.getShellCommand().getOutputs()) {
            if (n <= 0) continue;
            String string = commandOutput.getOutput().trim().replace("ms", "");
            Matcher matcher = TRACEROUTE_OUTPUT_PATTERN.matcher(string);
            if (matcher.matches()) {
                void tracerouteHop;
                TracerouteHop tracerouteHop2 = new TracerouteHop((TracerouteRequest)index, n, null, new IPAddress(matcher.group(2)));
                index.getTracerouteHops().add(tracerouteHop2);
                int n2 = 0;
                for (String string2 : tracerouteHop.group(3).split("  ")) {
                    void j;
                    try {
                        j.getTracrouteHopResponses().add(new TracrouteHopResponse(n2, Double.valueOf(string2).doubleValue(), (TracerouteHop)j));
                    }
                    catch (NumberFormatException numberFormatException) {
                        j.getTracrouteHopResponses().add(new TracrouteHopResponse(n2, -1.0, (TracerouteHop)j));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"doAfter", (Object[])new Object[]{tracerouteRequest}, null, (long)l);
    }
}

