/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.Chrootable;
import io.github.qsy7.shell.api.model.EnvironmentAware;
import io.github.qsy7.shell.api.model.FreeBSDJailShellCommand;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.model.ShellCommandEnvironmentProperty;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.ShellProcessExecution;
import io.github.qsy7.shell.impl.annotation.EntityEnabled;
import io.github.qsy7.shell.impl.property.InterruptGracePeriodUnits;
import io.github.qsy7.shell.impl.property.InterruptGracePeriodValue;
import io.github.qsy7.shell.impl.util.ShellExecutionUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.temporal.ChronoUnit;

public class DefaultShellExecution
implements ShellExecutionService,
AutoCloseable {
    protected boolean shutdown;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultShellExecution(@Property(value=InterruptGracePeriodUnits.class) ChronoUnit chronoUnit, @Property(value=InterruptGracePeriodValue.class) long l) {
        void interruptGracePeriodValue;
        void interruptGracePeriodUnits;
        DefaultShellExecution defaultShellExecution = this;
        ChronoUnit chronoUnit2 = chronoUnit;
        long l2 = l;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"<init>", (Object[])new Object[]{chronoUnit2, l2});
        DefaultShellExecution defaultShellExecution2 = defaultShellExecution;
        ChronoUnit chronoUnit3 = chronoUnit2;
        long l4 = l2;
        defaultShellExecution2.interruptGracePeriodUnits = interruptGracePeriodUnits;
        defaultShellExecution2.interruptGracePeriodValue = interruptGracePeriodValue;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"<init>", (Object[])new Object[]{chronoUnit2, l2}, null, (long)l3);
        CloseableUtil.addAutoCloseable((AutoCloseable)this);
    }

    /*
     * WARNING - void declaration
     */
    @EntityEnabled
    public ShellCommand run(ShellCommand shellCommand) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"run", (Object[])new Object[]{shellCommand});
        DefaultShellExecution defaultShellExecution = this;
        ShellCommand shellCommand2 = shellCommand;
        DefaultShellExecution defaultShellExecution2 = defaultShellExecution;
        ShellCommand shellCommand3 = shellCommand2;
        try {
            void shellCommand4;
            defaultShellExecution2.checkIfShutdown();
            defaultShellExecution2.doRun((ShellCommand)shellCommand4);
            defaultShellExecution2 = shellCommand4;
            return defaultShellExecution2;
        }
        finally {
            shellCommand3 = null;
        }
    }

    protected void checkIfShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"checkIfShutdown", (Object[])new Object[0]);
        DefaultShellExecution defaultShellExecution = this;
        DefaultShellExecution defaultShellExecution2 = defaultShellExecution;
        try {
            if (defaultShellExecution2.shutdown) {
                throw new IllegalStateException("Service is shutting down");
            }
            defaultShellExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultShellExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"checkIfShutdown", (Object[])new Object[0], (Throwable)((Object)defaultShellExecution2));
        }
        if (defaultShellExecution2 != null) {
            throw defaultShellExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"checkIfShutdown", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doRun(ShellCommand shellCommand) throws IOException, InterruptedException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doRun", (Object[])new Object[]{shellCommand});
        DefaultShellExecution defaultShellExecution = this;
        ShellCommand shellCommand2 = shellCommand;
        DefaultShellExecution defaultShellExecution2 = defaultShellExecution;
        ShellCommand shellCommand3 = shellCommand2;
        try {
            void shellCommand4;
            new ShellProcessExecution(defaultShellExecution2.setupProcess((ShellCommand)shellCommand4), (ShellCommand)shellCommand4, defaultShellExecution2.interruptGracePeriodUnits, defaultShellExecution2.interruptGracePeriodValue).run();
            defaultShellExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultShellExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doRun", (Object[])new Object[]{shellCommand2}, (Throwable)((Object)defaultShellExecution2));
        }
        if (defaultShellExecution2 != null) {
            throw defaultShellExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doRun", (Object[])new Object[]{shellCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Process setupProcess(ShellCommand shellCommand) throws IOException {
        Process process;
        ShellCommand shellCommand2;
        Object object;
        ShellCommand shellCommand3;
        Object object2;
        long l;
        block5: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setupProcess", (Object[])new Object[]{shellCommand});
            object2 = this;
            shellCommand3 = shellCommand;
            object = object2;
            shellCommand2 = shellCommand3;
            try {
                void shellCommand4;
                if (shellCommand4 instanceof Chrootable) {
                    process = shellCommand4 instanceof FreeBSDJailShellCommand ? ((DefaultShellExecution)object).doFreeBSDJailChrootProcess((ShellCommand)shellCommand4) : ((DefaultShellExecution)object).doChrootProcess((ShellCommand)shellCommand4);
                    break block5;
                }
                process = ShellExecutionUtil.doNonChrootProcess((ShellCommand)shellCommand4);
            }
            catch (Throwable throwable) {
                object = null;
            }
        }
        object = process;
        shellCommand2 = null;
        if (shellCommand2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setupProcess", (Object[])new Object[]{shellCommand3}, (Throwable)shellCommand2);
        }
        if (shellCommand2 != null) {
            throw shellCommand2;
        }
        object2 = object;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setupProcess", (Object[])new Object[]{shellCommand}, (Object)object2, (long)l);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    protected Process doFreeBSDJailChrootProcess(ShellCommand shellCommand) throws IOException {
        Process process;
        ShellCommand shellCommand2;
        Object object;
        ShellCommand shellCommand3;
        DefaultShellExecution defaultShellExecution;
        long l;
        block5: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doFreeBSDJailChrootProcess", (Object[])new Object[]{shellCommand});
            defaultShellExecution = this;
            shellCommand3 = shellCommand;
            object = defaultShellExecution;
            shellCommand2 = shellCommand3;
            try {
                void shellCommand4;
                Chrootable chrootable = (Chrootable)shellCommand4;
                ((DefaultShellExecution)object).doValidate((ShellCommand)shellCommand4, chrootable);
                if (shellCommand4 instanceof EnvironmentAware) {
                    ProcessBuilder processBuilder = new ProcessBuilder(ShellExecutionUtil.getProcessBuilderChrootCmdLine(chrootable));
                    DefaultShellExecution.setEnvironment(processBuilder, (EnvironmentAware)shellCommand4.getShellCommandEnvironmentProperties());
                    process = processBuilder.start();
                    break block5;
                }
                process = Runtime.getRuntime().exec(ShellExecutionUtil.getChrootCmdLine(chrootable));
            }
            catch (Throwable throwable) {
                object = null;
            }
        }
        object = process;
        shellCommand2 = null;
        if (shellCommand2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doFreeBSDJailChrootProcess", (Object[])new Object[]{shellCommand3}, (Throwable)shellCommand2);
        }
        if (shellCommand2 != null) {
            throw shellCommand2;
        }
        defaultShellExecution = object;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doFreeBSDJailChrootProcess", (Object[])new Object[]{shellCommand}, (Object)defaultShellExecution, (long)l);
        return defaultShellExecution;
    }

    /*
     * WARNING - void declaration
     */
    private static void setEnvironment(ProcessBuilder processBuilder, EnvironmentAware environmentAware) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironment", (Object[])new Object[]{processBuilder, environmentAware});
        ProcessBuilder processBuilder2 = processBuilder;
        EnvironmentAware environmentAware2 = environmentAware;
        ProcessBuilder processBuilder3 = processBuilder2;
        EnvironmentAware environmentAware3 = environmentAware2;
        try {
            void environmentAware4;
            for (ShellCommandEnvironmentProperty shellCommandEnvironmentProperty : environmentAware4.getShellCommandEnvironmentProperties()) {
                void processBuilder4;
                DefaultShellExecution.setEnvironmentProperty((ProcessBuilder)processBuilder4, shellCommandEnvironmentProperty);
            }
            processBuilder3 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (processBuilder3 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironment", (Object[])new Object[]{processBuilder2, environmentAware2}, (Throwable)((Object)processBuilder3));
        }
        if (processBuilder3 != null) {
            throw processBuilder3;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironment", (Object[])new Object[]{processBuilder, environmentAware}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    private static void setEnvironmentProperty(ProcessBuilder processBuilder, ShellCommandEnvironmentProperty shellCommandEnvironmentProperty) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironmentProperty", (Object[])new Object[]{processBuilder, shellCommandEnvironmentProperty});
        ProcessBuilder processBuilder2 = processBuilder;
        ShellCommandEnvironmentProperty shellCommandEnvironmentProperty2 = shellCommandEnvironmentProperty;
        ProcessBuilder processBuilder3 = processBuilder2;
        ShellCommandEnvironmentProperty shellCommandEnvironmentProperty3 = shellCommandEnvironmentProperty2;
        try {
            void shellCommandEnvironmentProperty4;
            void processBuilder4;
            processBuilder4.environment().put(shellCommandEnvironmentProperty4.getKey(), shellCommandEnvironmentProperty4.getValue());
            processBuilder3 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (processBuilder3 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironmentProperty", (Object[])new Object[]{processBuilder2, shellCommandEnvironmentProperty2}, (Throwable)((Object)processBuilder3));
        }
        if (processBuilder3 != null) {
            throw processBuilder3;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"setEnvironmentProperty", (Object[])new Object[]{processBuilder, shellCommandEnvironmentProperty}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Process doChrootProcess(ShellCommand shellCommand) throws IOException {
        Process process;
        ShellCommand shellCommand2;
        Object object;
        ShellCommand shellCommand3;
        DefaultShellExecution defaultShellExecution;
        long l;
        block5: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doChrootProcess", (Object[])new Object[]{shellCommand});
            defaultShellExecution = this;
            shellCommand3 = shellCommand;
            object = defaultShellExecution;
            shellCommand2 = shellCommand3;
            try {
                void shellCommand4;
                Chrootable chrootable = (Chrootable)shellCommand4;
                ((DefaultShellExecution)object).doValidate((ShellCommand)shellCommand4, chrootable);
                if (shellCommand4 instanceof EnvironmentAware && shellCommand4 instanceof EnvironmentAware) {
                    ProcessBuilder processBuilder = new ProcessBuilder(ShellExecutionUtil.getProcessBuilderChrootCmdLine(chrootable));
                    DefaultShellExecution.setEnvironment(processBuilder, (EnvironmentAware)shellCommand4);
                    process = processBuilder.start();
                    break block5;
                }
                process = Runtime.getRuntime().exec(ShellExecutionUtil.getChrootCmdLine(chrootable));
            }
            catch (Throwable throwable) {
                object = null;
            }
        }
        object = process;
        shellCommand2 = null;
        if (shellCommand2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doChrootProcess", (Object[])new Object[]{shellCommand3}, (Throwable)shellCommand2);
        }
        if (shellCommand2 != null) {
            throw shellCommand2;
        }
        defaultShellExecution = object;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doChrootProcess", (Object[])new Object[]{shellCommand}, (Object)defaultShellExecution, (long)l);
        return defaultShellExecution;
    }

    /*
     * WARNING - void declaration
     */
    protected void doValidate(ShellCommand shellCommand, Chrootable chrootable) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doValidate", (Object[])new Object[]{shellCommand, chrootable});
        DefaultShellExecution defaultShellExecution = this;
        ShellCommand shellCommand2 = shellCommand;
        Chrootable chrootable2 = chrootable;
        DefaultShellExecution defaultShellExecution2 = defaultShellExecution;
        ShellCommand shellCommand3 = shellCommand2;
        Chrootable chrootable3 = chrootable2;
        try {
            void chrootable4;
            if (chrootable4.getChrootPath() == null || chrootable4.getChrootPath().isEmpty()) {
                void shellCommand4;
                throw new IllegalStateException("Cannot chroot, chroot path is null:" + shellCommand4.getCommandLine());
            }
            defaultShellExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultShellExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doValidate", (Object[])new Object[]{shellCommand2, chrootable2}, (Throwable)((Object)defaultShellExecution2));
        }
        if (defaultShellExecution2 != null) {
            throw defaultShellExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"doValidate", (Object[])new Object[]{shellCommand, chrootable}, null, (long)l);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"close", (Object[])new Object[0]);
        DefaultShellExecution defaultShellExecution = this;
        DefaultShellExecution defaultShellExecution2 = defaultShellExecution;
        try {
            defaultShellExecution2.shutdown = true;
            defaultShellExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultShellExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"close", (Object[])new Object[0], (Throwable)((Object)defaultShellExecution2));
        }
        if (defaultShellExecution2 != null) {
            throw defaultShellExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultShellExecution", (String)"close", (Object[])new Object[0], null, (long)l);
    }
}

