/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.ssh;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.ssh.api.model.AbstractSSHEntity;
import java.io.File;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;

public abstract class AbstractSSHService<SSHEntityType extends AbstractSSHEntity> {
    protected final String sshPublicKeyPath;
    protected final SSHEntityType command;

    /*
     * WARNING - void declaration
     */
    protected AbstractSSHService(String string, SSHEntityType SSHEntityType) {
        void command;
        void sshPublicKeyPath;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"<init>", (Object[])new Object[]{string, SSHEntityType});
        AbstractSSHService abstractSSHService = this;
        String string2 = string;
        SSHEntityType SSHEntityType2 = SSHEntityType;
        sshPublicKeyPath.command = SSHEntityType2;
        sshPublicKeyPath.sshPublicKeyPath = command;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"<init>", (Object[])new Object[]{string, SSHEntityType}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Session setupSSH(SSHClient sSHClient, String string, String string2) throws IOException {
        void sshClient;
        void username;
        void host;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"setupSSH", (Object[])new Object[]{sSHClient, string, string2});
        AbstractSSHService abstractSSHService = this;
        SSHClient sSHClient2 = sSHClient;
        String string3 = string;
        String string4 = string2;
        host.loadKnownHosts();
        host.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        host.connect((String)username);
        host.authPublickey(string4, new String[]{sshClient.getPublicKeyPath()});
        abstractSSHService = host.startSession();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"setupSSH", (Object[])new Object[]{sSHClient, string, string2}, (Object)abstractSSHService, (long)l);
        return abstractSSHService;
    }

    protected String getPublicKeyPath() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getPublicKeyPath", (Object[])new Object[0]);
        Object object = this;
        object = ((AbstractSSHService)object).sshPublicKeyPath != null && !((AbstractSSHService)object).sshPublicKeyPath.isEmpty() ? ((AbstractSSHService)object).sshPublicKeyPath : ((AbstractSSHService)object).getDefaultPublicKeyPath();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getPublicKeyPath", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    protected String getDefaultPublicKeyPath() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getDefaultPublicKeyPath", (Object[])new Object[0]);
        Object object = this;
        object = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_ecdsa";
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getDefaultPublicKeyPath", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"execute", (Object[])new Object[0]);
        AbstractSSHService abstractSSHService = this;
        try (SSHClient sSHClient = new SSHClient();){
            void sshClient;
            try (Session session = sshClient.setupSSH(sSHClient, sshClient.command.getHost().getName(), sshClient.command.getUser().getName());){
                void session2;
                sshClient.doExecute((SSHClient)session2, session);
            }
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"execute", (Object[])new Object[0], null, (long)l);
    }

    protected abstract void doExecute(SSHClient var1, Session var2) throws Exception;
}

