package io.github.qsy7.ssh.service;

import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.ssh.api.SFTPTransferService;
import io.github.qsy7.ssh.api.SSHPublicKeyPath;
import io.github.qsy7.ssh.api.model.sftp.SFTPTransfer;
import io.github.qsy7.ssh.executor.SFTPExecutor;
import jakarta.inject.Inject;

public class DefaultSFTPTransferService implements SFTPTransferService {

  protected final String sshPublicKeyPath;

  @Inject
  public DefaultSFTPTransferService(
      @Property(SSHPublicKeyPath.class) final String sshPublicKeyPath) {

    this.sshPublicKeyPath = sshPublicKeyPath;
  }

  @Override
  public void transfer(SFTPTransfer... transfers) throws Exception {
    for (SFTPTransfer transfer : transfers) transfer(transfer);
  }

  protected void transfer(SFTPTransfer transfer) throws Exception {
    new SFTPExecutor(sshPublicKeyPath, transfer).execute();
  }
}
