/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.ssh;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.ssh.api.model.AbstractSSHEntity;
import java.io.File;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;

public abstract class AbstractSSHService<SSHEntityType extends AbstractSSHEntity> {
    protected final String sshPublicKeyPath;
    protected final SSHEntityType command;

    /*
     * WARNING - void declaration
     */
    protected AbstractSSHService(String string, SSHEntityType SSHEntityType) {
        void sshPublicKeyPath;
        void command;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"<init>", (Object[])new Object[]{string, SSHEntityType});
        AbstractSSHService abstractSSHService = this;
        String string2 = string;
        SSHEntityType SSHEntityType2 = SSHEntityType;
        abstractSSHService.command = command;
        abstractSSHService.sshPublicKeyPath = sshPublicKeyPath;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"<init>", (Object[])new Object[]{string, SSHEntityType}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected Session setupSSH(SSHClient sSHClient, String string, String string2) throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"setupSSH", (Object[])new Object[]{sSHClient, string, string2});
        AbstractSSHService abstractSSHService = this;
        SSHClient sSHClient2 = sSHClient;
        String string3 = string;
        String string4 = string2;
        AbstractSSHService abstractSSHService2 = abstractSSHService;
        SSHClient sSHClient3 = sSHClient2;
        String string5 = string3;
        String string6 = string4;
        try {
            void username;
            void host;
            void sshClient;
            sshClient.loadKnownHosts();
            sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            sshClient.connect((String)host);
            sshClient.authPublickey((String)username, new String[]{abstractSSHService2.getPublicKeyPath()});
            abstractSSHService2 = sshClient.startSession();
            return abstractSSHService2;
        }
        finally {
            sSHClient3 = null;
        }
    }

    protected String getPublicKeyPath() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getPublicKeyPath", (Object[])new Object[0]);
        Object object = this;
        Object object2 = object;
        try {
            object2 = ((AbstractSSHService)object2).sshPublicKeyPath != null && !((AbstractSSHService)object2).sshPublicKeyPath.isEmpty() ? ((AbstractSSHService)object2).sshPublicKeyPath : ((AbstractSSHService)object2).getDefaultPublicKeyPath();
        }
        catch (Throwable throwable) {
            object2 = null;
        }
        Throwable throwable = null;
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getPublicKeyPath", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        object = object2;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getPublicKeyPath", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    protected String getDefaultPublicKeyPath() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"getDefaultPublicKeyPath", (Object[])new Object[0]);
        AbstractSSHService abstractSSHService = this;
        Object object = abstractSSHService;
        try {
            object = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_ecdsa";
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public void execute() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"execute", (Object[])new Object[0]);
        AbstractSSHService abstractSSHService = this;
        AbstractSSHService abstractSSHService2 = abstractSSHService;
        try {
            try (SSHClient sshClient = new SSHClient();
                 Session session = abstractSSHService2.setupSSH(sshClient, abstractSSHService2.command.getHost().getName(), abstractSSHService2.command.getUser().getName());){
                abstractSSHService2.doExecute(sshClient, session);
            }
            abstractSSHService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractSSHService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.AbstractSSHService", (String)"execute", (Object[])new Object[0], (Throwable)((Object)abstractSSHService2));
        }
        if (abstractSSHService2 != null) {
            throw abstractSSHService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.AbstractSSHService", (String)"execute", (Object[])new Object[0], null, (long)l);
    }

    protected abstract void doExecute(SSHClient var1, Session var2) throws Exception;
}

