/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

package com.facebook.react.devsupport;

import android.content.Context;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;

/**
 * Interface for accessing and interacting with development features related to performance testing.
 * Communication is enabled via the Inspector, but everything else is disabled.
 */
@Nullsafe(Nullsafe.Mode.LOCAL)
public final class PerftestDevSupportManager extends ReleaseDevSupportManager {
  private final DevServerHelper mDevServerHelper;
  private final DeveloperSettings mDevSettings;

  public PerftestDevSupportManager(Context applicationContext) {
    mDevSettings =
        new DevInternalSettings(
            applicationContext,
            new DevInternalSettings.Listener() {
              @Override
              public void onInternalSettingsChanged() {}
            });
    mDevServerHelper =
        new DevServerHelper(
            mDevSettings, applicationContext, mDevSettings.getPackagerConnectionSettings());
  }

  @Override
  public DeveloperSettings getDevSettings() {
    return mDevSettings;
  }

  @Override
  public void startInspector() {
    mDevServerHelper.openInspectorConnection();
  }

  @Override
  public void stopInspector() {
    mDevServerHelper.closeInspectorConnection();
  }
}
