/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.diff;

import com.sksamuel.diffpatch.DiffMatchPatch;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class DiffAssert
extends AbstractAssert<DiffAssert, Path> {
    public DiffAssert(Path actual) {
        super((Object)actual, DiffAssert.class);
    }

    public DiffAssert isEqualTo(Path expected, Path reportPath) {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffAssert.diff((Path)this.actual, expected);
        boolean allDiffsAreEqual = this.assertThatAllDiffsAreEqual(diffs);
        if (!allDiffsAreEqual) {
            DiffAssert.writeHtmlReport(reportPath, diffs);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)allDiffsAreEqual).as("The content of the following files differ. Actual: %s, Expected %s. Check the HTML report for more details: %s", new Object[]{((Path)this.actual).toAbsolutePath(), expected.toAbsolutePath(), reportPath.toAbsolutePath()})).isTrue();
        return (DiffAssert)this.myself;
    }

    public boolean assertThatAllDiffsAreEqual(LinkedList<DiffMatchPatch.Diff> diffs) {
        for (DiffMatchPatch.Diff diff : diffs) {
            if (diff.operation != DiffMatchPatch.Operation.DELETE && diff.operation != DiffMatchPatch.Operation.INSERT) continue;
            return false;
        }
        return true;
    }

    private static LinkedList<DiffMatchPatch.Diff> diff(Path actual, Path expected) {
        DiffMatchPatch differ = new DiffMatchPatch();
        try {
            return differ.diff_main(IOUtils.toString((URI)expected.toUri()), IOUtils.toString((URI)actual.toUri()), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to diff files.", e);
        }
    }

    private static void writeHtmlReport(Path reportPath, LinkedList<DiffMatchPatch.Diff> diffs) {
        DiffMatchPatch differ = new DiffMatchPatch();
        try {
            Files.createDirectories(reportPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(reportPath, Charset.forName("UTF-8"), new OpenOption[0]);){
                writer.write(differ.diff_prettyHtml(diffs));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to write report %s", reportPath.toAbsolutePath()), e);
        }
    }
}

