/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.string;

import io.github.scarecraw22.utils.string.StringUtilsException;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    @NotNull
    public static String getFirstNChars(@NotNull(value="input cannot be null", exception=StringUtilsException.class) @NotNull(value="input cannot be null", exception=StringUtilsException.class) String input, int n) {
        if (input.length() < n) {
            throw new StringUtilsException("Cannot retrieve first " + n + " chars from string: \"" + input + "\". String is too short.");
        }
        if (n <= 0) {
            throw new StringUtilsException("Given n must be positive. Current value of n: " + n);
        }
        return input.substring(0, n);
    }

    @NotNull
    public static String getFirstChar(@NotNull(value="input cannot be null", exception=StringUtilsException.class) @NotNull(value="input cannot be null", exception=StringUtilsException.class) String input) {
        return StringUtils.getFirstNChars(input, 1);
    }

    @NotNull
    public static String getLastNChars(@NotNull(value="input cannot be null", exception=StringUtilsException.class) @NotNull(value="input cannot be null", exception=StringUtilsException.class) String input, int n) {
        if (input.length() < n) {
            throw new StringUtilsException("Cannot retrieve last " + n + " chars from string: \"" + input + "\". String is too short.");
        }
        if (n <= 0) {
            throw new StringUtilsException("Given n must be positive. Current value of n: " + n);
        }
        return input.substring(input.length() - n);
    }

    @NotNull
    public static String getLastChar(@NotNull(value="input cannot be null", exception=StringUtilsException.class) @NotNull(value="input cannot be null", exception=StringUtilsException.class) String input) {
        return StringUtils.getLastNChars(input, 1);
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

