/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.docker.containers;

import io.github.scarecraw22.utils.docker.containers.BaseContainer;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;

public class SftpServerContainer
extends BaseContainer {
    private static final String DOCKER_IMAGE = "lscr.io/linuxserver/openssh-server:latest";
    private static final String PUID = "PUID";
    private static final String PGID = "PGID";
    private static final String TIMEZONE = "TZ";
    private static final String PASSWORD_ACCESS = "PASSWORD_ACCESS";
    private static final String PASSWORD_ACCESS_VALUE = "true";
    private static final String USER_NAME = "USER_NAME";
    private static final String USER_PASSWORD = "USER_PASSWORD";
    private final Map<String, String> envs;

    public SftpServerContainer() {
        this(SftpServerContainer.getDefaultEnvs(), 2222);
    }

    public SftpServerContainer(Map<String, String> envs, int exposedPort) {
        super(new GenericContainer(DOCKER_IMAGE).withEnv(envs).withExposedPorts(new Integer[]{exposedPort}), "sftp-server");
        this.envs = envs;
    }

    public String getUsername() {
        return this.envs.get(USER_NAME);
    }

    public String getPassword() {
        return this.envs.get(USER_PASSWORD);
    }

    private static Map<String, String> getDefaultEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put(PUID, "1000");
        envs.put(PGID, "1000");
        envs.put(TIMEZONE, "Europe/Warsaw");
        envs.put(PASSWORD_ACCESS, PASSWORD_ACCESS_VALUE);
        envs.put(USER_NAME, "ssh-user");
        envs.put(USER_PASSWORD, "ssh-user-password");
        return envs;
    }
}

