/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.file;

import io.github.scarecraw22.utils.file.FileNotFoundException;
import io.github.scarecraw22.utils.file.FileUtilsException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileUtils {
    private static final Logger log = LogManager.getLogger(FileUtils.class);

    public static Path getFileFromResources(@NonNull String pathString) {
        if (pathString == null) {
            throw new NullPointerException("pathString is marked non-null but is null");
        }
        try {
            URL url = FileUtils.class.getClassLoader().getResource(pathString);
            if (url == null) {
                throw new FileNotFoundException("File: " + pathString + " not found");
            }
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new FileUtilsException(e);
        }
    }

    public static String readFileFromResourcesToString(@NonNull String pathString) {
        if (pathString == null) {
            throw new NullPointerException("pathString is marked non-null but is null");
        }
        return FileUtils.readFileToString(FileUtils.getFileFromResources(pathString));
    }

    public static String readFileToString(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(path));
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    public static void copyFile(@NonNull Path src, @NonNull Path dst) {
        if (src == null) {
            throw new NullPointerException("src is marked non-null but is null");
        }
        if (dst == null) {
            throw new NullPointerException("dst is marked non-null but is null");
        }
        try {
            if (!dst.toFile().exists()) {
                Files.createFile(dst, new FileAttribute[0]);
            } else {
                log.warn("Destination file: {} already exists and it will be replaced!", (Object)dst);
            }
            Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    public static Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    public static byte[] toBytes(@NonNull Path file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    public static byte[] toBytes(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FileUtils.toBytes(file.toPath());
    }

    public static void deleteDir(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Arrays.asList(files).forEach(FileUtils::deleteDir);
            }
            file.delete();
        } else if (file.isFile()) {
            FileUtils.deleteFile(file);
        } else {
            throw new FileUtilsException("Given object is not a file and not a directory: " + file);
        }
    }

    public static void deleteDir(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        FileUtils.deleteDir(path.toFile());
    }

    public static void createDirs(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void createDirs(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        FileUtils.createDirs(path.toFile());
    }

    public static Path createTmpFile(@NonNull String prefix, @NonNull String suffix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        try {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    public static Path getTmpDir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static void deleteFile(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.toFile().isDirectory()) {
            throw new FileUtilsException("Given path is a directory. Use deleteDir() method to delete directory.");
        }
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    public static void deleteFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileUtils.deleteFile(file.toPath());
    }

    public static void writeInputStreamToFile(@NonNull InputStream inputStream, @NonNull Path target) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try {
            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    public static void writeBytesToFile(Path destination, byte[] bytesToWrite) {
        try {
            Files.write(destination, bytesToWrite, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FileUtilsException(e);
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

