/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.github.scarecraw22.utils.file.FileUtils;
import io.github.scarecraw22.utils.file.FileUtilsException;
import io.github.scarecraw22.utils.sftp.DownloadFileSftpException;
import io.github.scarecraw22.utils.sftp.SftpClient;
import io.github.scarecraw22.utils.sftp.SftpConfig;
import io.github.scarecraw22.utils.sftp.SftpException;
import io.github.scarecraw22.utils.sftp.UploadFileSftpException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JschSftpClient
implements SftpClient {
    private static final Logger log = LogManager.getLogger(JschSftpClient.class);
    private final JSch jsch;
    private final SftpConfig sftpConfig;

    @Override
    public void upload(InputStream inputStream, String destinationPath) throws UploadFileSftpException {
        this.tryOrThrowUploadException(channelSftp -> this.tryUploadOrThrowUploadException(channelSftp, inputStream, destinationPath));
    }

    @Override
    public void upload(Path sourceFile, String destinationPath) throws UploadFileSftpException {
        this.tryOrThrowUploadException(channelSftp -> {
            try (InputStream inputStream = Files.newInputStream(sourceFile, new OpenOption[0]);){
                this.tryUploadOrThrowUploadException(channelSftp, inputStream, destinationPath);
            }
            catch (IOException e) {
                log.warn("Error while creating InputStream from file: {}", (Object)sourceFile);
                throw new UploadFileSftpException(e);
            }
        });
    }

    @Override
    public void download(String sourcePath, Path destinationFile) throws DownloadFileSftpException {
        this.tryOrThrowDownloadException(channelSftp -> {
            try {
                FileUtils.writeInputStreamToFile(this.tryDownloadOrThrowDownloadException(channelSftp, sourcePath), destinationFile);
            }
            catch (FileUtilsException e) {
                log.warn("Error while trying to copy InputStream to file: {}", (Object)destinationFile);
                throw new DownloadFileSftpException(e);
            }
        });
    }

    @Override
    public void download(String sourcePath, Consumer<InputStream> onDownloadConsumer) throws DownloadFileSftpException {
        this.tryOrThrowDownloadException(channelSftp -> {
            try (InputStream inputStream = this.tryDownloadOrThrowDownloadException(channelSftp, sourcePath);){
                onDownloadConsumer.accept(inputStream);
            }
            catch (IOException e) {
                log.warn("Error while closing InputStream");
                throw new DownloadFileSftpException(e);
            }
        });
    }

    private InputStream tryDownloadOrThrowDownloadException(ChannelSftp channelSftp, String sourcePath) throws DownloadFileSftpException {
        try {
            log.debug("Trying to download file: {}", (Object)sourcePath);
            return channelSftp.get(sourcePath);
        }
        catch (com.jcraft.jsch.SftpException e) {
            log.warn("Error while downloading file from: {}", (Object)sourcePath);
            throw new DownloadFileSftpException(e);
        }
    }

    private void tryUploadOrThrowUploadException(ChannelSftp channelSftp, InputStream inputStream, String destinationPath) throws UploadFileSftpException {
        try {
            log.debug("Trying to upload file to: {}", (Object)destinationPath);
            channelSftp.put(inputStream, destinationPath);
        }
        catch (com.jcraft.jsch.SftpException e) {
            log.warn("Error while uploading file to: {}", (Object)destinationPath);
            throw new UploadFileSftpException(e);
        }
    }

    private void tryOrThrowUploadException(ChannelSftpConsumer consumer) throws UploadFileSftpException {
        try {
            this.doOnConnected(consumer);
        }
        catch (SftpException e) {
            throw new UploadFileSftpException(e);
        }
    }

    private void tryOrThrowDownloadException(ChannelSftpConsumer consumer) throws DownloadFileSftpException {
        try {
            this.doOnConnected(consumer);
        }
        catch (SftpException e) {
            throw new DownloadFileSftpException(e);
        }
    }

    private void doOnConnected(ChannelSftpConsumer consumer) throws SftpException {
        String host = this.sftpConfig.getHost();
        Integer port = this.sftpConfig.getPort();
        Session session = null;
        ChannelSftp channelSftp = null;
        log.debug("Trying to connect to: {}:{}", (Object)host, (Object)port);
        try {
            session = this.jsch.getSession(this.sftpConfig.getUsername(), this.sftpConfig.getHost(), this.sftpConfig.getPort().intValue());
            session.setPassword(this.sftpConfig.getPassword().getBytes(StandardCharsets.UTF_8));
            if (this.sftpConfig.getSshProperties() != null) {
                session.setConfig(this.sftpConfig.getSshProperties());
            }
            session.connect();
            log.debug("Connected !");
            log.debug("Trying to open SFTP channel");
            channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect();
            log.debug("Opened !");
            consumer.accept(channelSftp);
        }
        catch (JSchException e) {
            log.warn("Error while connecting to: {}:{}", (Object)host, (Object)port);
            throw new SftpException(e);
        }
        finally {
            if (channelSftp != null) {
                log.debug("Trying to close SFTP channel");
                channelSftp.disconnect();
            }
            if (session != null) {
                log.debug("Trying to close session");
                session.disconnect();
            }
        }
    }

    public JschSftpClient(JSch jsch, SftpConfig sftpConfig) {
        this.jsch = jsch;
        this.sftpConfig = sftpConfig;
    }

    private static interface ChannelSftpConsumer {
        public void accept(ChannelSftp var1) throws SftpException;
    }
}

