/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.scarecraw22.utils.file.FileUtils;
import java.nio.file.Paths;
import org.springframework.http.HttpStatus;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class MvcResponseChecker {
    private final ResultActions resultActions;
    private final ObjectMapper objectMapper;

    public MvcResponseChecker expectStatus(int statusCode) throws Exception {
        this.resultActions.andExpect(MockMvcResultMatchers.status().is(statusCode));
        return this;
    }

    public MvcResponseChecker expectStatus(HttpStatus httpStatus) throws Exception {
        return this.expectStatus(httpStatus.value());
    }

    public MvcResponseChecker expectOk() throws Exception {
        return this.expectStatus(HttpStatus.OK);
    }

    public MvcResponseChecker expectBadRequest() throws Exception {
        return this.expectStatus(HttpStatus.BAD_REQUEST);
    }

    public MvcResponseChecker expectNotFound() throws Exception {
        return this.expectStatus(HttpStatus.NOT_FOUND);
    }

    public MvcResponseChecker expectConflict() throws Exception {
        return this.expectStatus(HttpStatus.CONFLICT);
    }

    public MvcResponseChecker expectJson(String body) throws Exception {
        this.resultActions.andExpect(MockMvcResultMatchers.content().json(body));
        return this;
    }

    public MvcResponseChecker expectJsonFromFile(String pathToFile) throws Exception {
        return this.expectJson(FileUtils.readFileToString(Paths.get(pathToFile, new String[0])));
    }

    public String getResponseBodyAsString() throws Exception {
        return this.resultActions.andReturn().getResponse().getContentAsString();
    }

    public <T> T getResponseBodyAs(Class<T> clazz) throws Exception {
        return (T)this.objectMapper.readValue(this.getResponseBodyAsString(), clazz);
    }

    public MvcResponseChecker expectBodyFile(String pathToFile) throws Exception {
        return this.expectBody(FileUtils.readFileToString(Paths.get(pathToFile, new String[0])));
    }

    public MvcResponseChecker expectBody(String body) throws Exception {
        this.resultActions.andExpect(MockMvcResultMatchers.content().string(body.trim()));
        return this;
    }

    public MvcResponseChecker(ResultActions resultActions, ObjectMapper objectMapper) {
        this.resultActions = resultActions;
        this.objectMapper = objectMapper;
    }
}

