/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.docker.containers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class BaseContainer {
    private static final Logger log = LoggerFactory.getLogger(BaseContainer.class);
    protected final GenericContainer container;
    protected final String name;

    public BaseContainer(GenericContainer container, String name) {
        this.container = container;
        this.name = name;
    }

    public synchronized void startWithStopOnShutdown() {
        if (!this.container.isRunning()) {
            this.container.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.container.isRunning()) {
                    log.info("Stopping {} container", (Object)this.name);
                    this.container.stop();
                    log.info("{} container stopped", (Object)this.name);
                }
            }));
        } else {
            log.info("{} container already running", (Object)this.name);
        }
    }

    public synchronized void stop() {
        if (this.container.isRunning()) {
            this.container.stop();
        }
    }

    public String getContainerHostAddress() {
        return this.container.getHost();
    }

    public Integer getFirstMappedPort() {
        return this.container.getFirstMappedPort();
    }
}

