/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.string;

import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    @NotNull
    public static String getFirstNChars(@NonNull @NotNull(value="input cannot be null") @NonNull @NotNull(value="input cannot be null") String input, int n) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.length() < n) {
            throw new IllegalArgumentException("Cannot retrieve first " + n + " chars from string: \"" + input + "\". String is too short.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Given n must be positive. Current value of n: " + n);
        }
        return input.substring(0, n);
    }

    @NotNull
    public static String getFirstChar(@NonNull @NotNull(value="input cannot be null") @NonNull @NotNull(value="input cannot be null") String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtils.getFirstNChars(input, 1);
    }

    @NotNull
    public static String getLastNChars(@NonNull @NotNull(value="input cannot be null") @NonNull @NotNull(value="input cannot be null") String input, int n) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.length() < n) {
            throw new IllegalArgumentException("Cannot retrieve last " + n + " chars from string: \"" + input + "\". String is too short.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Given n must be positive. Current value of n: " + n);
        }
        return input.substring(input.length() - n);
    }

    @NotNull
    public static String getLastChar(@NonNull @NotNull(value="input cannot be null") @NonNull @NotNull(value="input cannot be null") String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtils.getLastNChars(input, 1);
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

