/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionUtils {
    private static final Logger log = LoggerFactory.getLogger(CollectionUtils.class);

    public static <T> CollectionOperations<T> of(Collection<T> collection) {
        return new CollectionOperations<T>(collection);
    }

    private CollectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class CollectionOperations<T> {
        private final Collection<T> collection;

        public boolean isEmpty() {
            return this.collection == null || this.collection.isEmpty();
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public boolean hasSize(int expectedSize) {
            boolean expectedSizeEqualsZero;
            if (expectedSize < 0) {
                throw new IllegalArgumentException("Argument expectedSize should be greater or equal zero. Actual: " + expectedSize);
            }
            boolean isEmpty = this.isEmpty();
            boolean bl = expectedSizeEqualsZero = expectedSize == 0;
            if (isEmpty && expectedSizeEqualsZero) {
                return true;
            }
            if (isEmpty) {
                return false;
            }
            return this.collection.size() == expectedSize;
        }

        public void applyForEach(Consumer<T> consumer) {
            if (this.isEmpty()) {
                log.warn("Given collection is empty. Cannot apply forEach()");
                return;
            }
            this.collection.forEach(consumer);
        }

        public <OUT> List<OUT> mapThenToList(Function<T, OUT> mapFunction) {
            return ((Collection)Optional.ofNullable(this.collection).orElse(Collections.emptyList())).stream().map(mapFunction).collect(Collectors.toList());
        }

        public <OUT> Set<OUT> mapThenToSet(Function<T, OUT> mapFunction) {
            return ((Collection)Optional.ofNullable(this.collection).orElse(Collections.emptyList())).stream().map(mapFunction).collect(Collectors.toSet());
        }

        public Optional<T> findFirst() {
            return ((Collection)Optional.ofNullable(this.collection).orElse(Collections.emptyList())).stream().findFirst();
        }

        public CollectionOperations(Collection<T> collection) {
            this.collection = collection;
        }
    }
}

