/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.string;

import lombok.NonNull;

public final class StringUtils {
    public static StringOperations of(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return new StringOperations(input);
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class StringOperations {
        private final String input;

        public String getFirstNChars(int n) {
            if (this.input.length() < n) {
                throw new IllegalArgumentException("Cannot retrieve first " + n + " chars from string: \"" + this.input + "\". String is too short.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("Given n must be positive. Current value of n: " + n);
            }
            return this.input.substring(0, n);
        }

        public String getFirstChar() {
            return this.getFirstNChars(1);
        }

        public String getLastNChars(int n) {
            if (this.input.length() < n) {
                throw new IllegalArgumentException("Cannot retrieve last " + n + " chars from string: \"" + this.input + "\". String is too short.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("Given n must be positive. Current value of n: " + n);
            }
            return this.input.substring(this.input.length() - n);
        }

        public String getLastChar() {
            return this.getLastNChars(1);
        }

        public boolean isEmptyOrBlank() {
            return this.input.isEmpty() || this.input.isBlank();
        }

        public boolean isValueSet() {
            return !this.isEmptyOrBlank();
        }

        public StringOperations(String input) {
            this.input = input;
        }
    }
}

