/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionUtils {
    private static final Logger log = LoggerFactory.getLogger(CollectionUtils.class);

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> boolean hasSize(Collection<T> collection, int expectedSize) {
        boolean expectedSizeEqualsZero;
        if (expectedSize < 0) {
            throw new IllegalArgumentException("Argument expectedSize should be greater or equal zero. Actual: " + expectedSize);
        }
        boolean isEmpty = CollectionUtils.isEmpty(collection);
        boolean bl = expectedSizeEqualsZero = expectedSize == 0;
        if (isEmpty && expectedSizeEqualsZero) {
            return true;
        }
        if (isEmpty) {
            return false;
        }
        return collection.size() == expectedSize;
    }

    public static <T> void applyForEach(Collection<T> collection, Consumer<T> consumer) {
        if (CollectionUtils.isEmpty(collection)) {
            log.warn("Given collection is empty. Cannot apply forEach()");
            return;
        }
        collection.forEach(consumer);
    }

    public static <T> Optional<T> first(Collection<T> collection) {
        return ((Collection)Optional.ofNullable(collection).orElse(Collections.emptyList())).stream().findFirst();
    }

    private CollectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

