/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.port;

import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortUtils {
    private static final Logger log = LoggerFactory.getLogger(PortUtils.class);

    public static int getFreePort() {
        int n;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't find any free port", e);
            }
        }
        serverSocket.close();
        return n;
    }

    private PortUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

