/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.string;

import lombok.NonNull;

public final class StringUtils {
    public static String getFirstNChars(@NonNull String input, int n) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.length() < n) {
            throw new IllegalArgumentException("Cannot retrieve first " + n + " chars from string: \"" + input + "\". String is too short.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Given n must be positive. Current value of n: " + n);
        }
        return input.substring(0, n);
    }

    public static String getFirstChar(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtils.getFirstNChars(input, 1);
    }

    public static String getLastNChars(@NonNull String input, int n) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.length() < n) {
            throw new IllegalArgumentException("Cannot retrieve last " + n + " chars from string: \"" + input + "\". String is too short.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Given n must be positive. Current value of n: " + n);
        }
        return input.substring(input.length() - n);
    }

    public static String getLastChar(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtils.getLastNChars(input, 1);
    }

    public static boolean isEmptyOrBlank(String input) {
        return input == null || input.isEmpty() || input.isBlank();
    }

    public static boolean isValueSet(String input) {
        return !StringUtils.isEmptyOrBlank(input);
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

