/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.docker.containers;

import io.github.scarecraw22.utils.docker.containers.BaseContainer;
import java.nio.file.Path;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class RedisContainer
extends BaseContainer {
    private static final int DEFAULT_PORT = 6379;

    public RedisContainer(Path redisConfig) {
        this(redisConfig, 6379);
    }

    public RedisContainer(Path redisConfig, int exposedPort) {
        super(new GenericContainer(DockerImageName.parse((String)"redis:7.0.2-alpine")).withCopyFileToContainer(MountableFile.forHostPath((Path)redisConfig), "/usr/local/etc/redis/redis.conf").withCommand(new String[]{"redis-server", "/usr/local/etc/redis/redis.conf"}).withExposedPorts(new Integer[]{exposedPort}), "redis");
    }
}

