/*
 * Decompiled with CFR 0.152.
 */
package io.github.scarecraw22.utils.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.scarecraw22.utils.file.FileUtils;
import io.github.scarecraw22.utils.test.MvcResponseChecker;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public class MvcRequestBuilder {
    private final MockMvc mockMvc;
    private final ObjectMapper objectMapper;
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean withRequestBuilder = false;
    private MockHttpServletRequestBuilder requestBuilder;
    private String url;
    private HttpMethod httpMethod;
    private MediaType contentType;
    private String body;

    public MvcRequestBuilder withMethod(HttpMethod method) {
        this.httpMethod = method;
        return this;
    }

    public MvcRequestBuilder post() {
        this.httpMethod = HttpMethod.POST;
        return this;
    }

    public MvcRequestBuilder patch() {
        this.httpMethod = HttpMethod.PATCH;
        return this;
    }

    public MvcRequestBuilder put() {
        this.httpMethod = HttpMethod.PATCH;
        return this;
    }

    public MvcRequestBuilder get() {
        this.httpMethod = HttpMethod.GET;
        return this;
    }

    public MvcRequestBuilder delete() {
        this.httpMethod = HttpMethod.DELETE;
        return this;
    }

    public MvcRequestBuilder url(String url) {
        this.url = url;
        return this;
    }

    public MvcRequestBuilder contentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    public MvcRequestBuilder withHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
        return this;
    }

    public MvcRequestBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public MvcRequestBuilder withBodyFromFile(String pathToFile) {
        this.body = FileUtils.readFileToString(Paths.get(pathToFile, new String[0]));
        return this;
    }

    public MvcRequestBuilder withRequestBuilder(MockHttpServletRequestBuilder requestBuilder) {
        this.withRequestBuilder = true;
        this.requestBuilder = requestBuilder;
        return this;
    }

    public MvcResponseChecker execute() throws Exception {
        if (this.withRequestBuilder) {
            return new MvcResponseChecker(this.mockMvc.perform((RequestBuilder)this.requestBuilder), this.objectMapper);
        }
        if (this.httpMethod == null) {
            throw new IllegalStateException("HttpMethod is not set. Use method() method on: " + MvcRequestBuilder.class.getName() + " class");
        }
        if (this.url == null || this.url.isBlank()) {
            throw new IllegalStateException("Url is not set. Use url method on: " + MvcRequestBuilder.class.getName() + " class");
        }
        if (this.contentType == null) {
            this.contentType = MediaType.APPLICATION_JSON;
        }
        MockHttpServletRequestBuilder requestBuilder = MockMvcRequestBuilders.request((HttpMethod)this.httpMethod, (String)this.url, (Object[])new Object[0]).contentType(this.contentType);
        requestBuilder = this.addHeaders(requestBuilder, this.headers);
        if (this.body != null) {
            requestBuilder = requestBuilder.content(this.body);
        }
        return new MvcResponseChecker(this.mockMvc.perform((RequestBuilder)requestBuilder), this.objectMapper);
    }

    private MockHttpServletRequestBuilder addHeaders(MockHttpServletRequestBuilder builder, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder = builder.header(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return builder;
    }

    public MvcRequestBuilder(MockMvc mockMvc, ObjectMapper objectMapper) {
        this.mockMvc = mockMvc;
        this.objectMapper = objectMapper;
    }
}

