/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import scouter.agent.Configure;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.util.Hexa32;
import scouter.util.KeyGen;

public class ForHttpURLConnection
implements ApiCallTraceHelper.IHelper {
    static Class httpclass = null;
    static Field inputStream = null;

    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep step = new ApiCallStep();
        try {
            if (hookPoint.this1 instanceof sun.net.www.protocol.http.HttpURLConnection && inputStream.get(hookPoint.this1) != null) {
                return null;
            }
            HttpURLConnection urlCon = (HttpURLConnection)hookPoint.this1;
            if ("connect".equals(hookPoint.method)) {
                step.txid = KeyGen.next();
                this.transfer(ctx, urlCon, step.txid);
                ctx.callee = step.txid;
                return null;
            }
            if (ctx.callee == 0L) {
                step.txid = KeyGen.next();
                this.transfer(ctx, urlCon, step.txid);
            } else {
                step.txid = ctx.callee;
                ctx.callee = 0L;
            }
            URL url = urlCon.getURL();
            ctx.apicall_name = url.getPath();
            step.opt = 1;
            step.address = url.getHost() + ":" + url.getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ctx.apicall_name == null) {
            ctx.apicall_name = hookPoint.class1;
        }
        return step;
    }

    private void transfer(TraceContext ctx, HttpURLConnection urlCon, long calleeTxid) {
        Configure conf = Configure.getInstance();
        if (conf.trace_interservice_enabled) {
            if (ctx.gxid == 0L) {
                ctx.gxid = ctx.txid;
            }
            try {
                urlCon.setRequestProperty(conf._trace_interservice_gxid_header_key, Hexa32.toString32(ctx.gxid));
                urlCon.setRequestProperty(conf._trace_interservice_callee_header_key, Hexa32.toString32(calleeTxid));
                urlCon.setRequestProperty(conf._trace_interservice_caller_header_key, Hexa32.toString32(ctx.txid));
                PluginHttpCallTrace.call(ctx, urlCon);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void checkTarget(HookArgs hookPoint) {
    }

    static {
        try {
            httpclass = sun.net.www.protocol.http.HttpURLConnection.class;
            inputStream = httpclass.getDeclaredField("inputStream");
            inputStream.setAccessible(true);
        }
        catch (Throwable e) {
            inputStream = null;
            httpclass = null;
        }
    }
}

